/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.model.IDataFilterRule;
import jayeson.model.IFilterEventDispatcher;
import jayeson.model.IFilterEventListener;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="class")
public interface IDataFilter
extends Serializable,
IFilterEventListener,
Comparable<IDataFilter>,
Cloneable {
    public Collection<IDataFilterRule> getFilterRules();

    public void setFilterRules(Collection<IDataFilterRule> var1);

    public void addFilterRule(IDataFilterRule var1);

    public void removeFilterRule(IDataFilterRule var1);

    public boolean isRunnable();

    public boolean isPassed(IBetMatch var1, ISnapshot<?> var2);

    public boolean isPassed(IBetEvent var1, ISnapshot<?> var2);

    public boolean isPassed(IBetRecord var1, ISnapshot<?> var2);

    public void setExecutor(ScheduledExecutorService var1);

    public void startAllRunnableRules();

    public void stopAllRunnableRules();

    public void addFilterRule(IDataFilterRule var1, boolean var2);

    public void replaceFilterRule(IDataFilterRule var1, boolean var2);

    public void setFilterRules(Collection<IDataFilterRule> var1, boolean var2);

    default public void registerAllEventsFromRules() {
        Collection<IDataFilterRule> filterRules = this.getFilterRules();
        for (IDataFilterRule rule : filterRules) {
            if (!(rule instanceof IFilterEventDispatcher)) continue;
            this.registerDispatcher((IFilterEventDispatcher)((Object)rule));
        }
    }

    default public void deregisterAllEventsFromRules() {
        Collection<IDataFilterRule> filterRules = this.getFilterRules();
        for (IDataFilterRule rule : filterRules) {
            if (!(rule instanceof IFilterEventDispatcher)) continue;
            this.deregisterDispatcher((IFilterEventDispatcher)((Object)rule));
        }
    }
}

