/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filter.soccer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.soccer.SoccerEvent;
import jayeson.lib.feed.soccer.SoccerEventState;
import jayeson.lib.feed.soccer.SoccerEventType;
import jayeson.lib.feed.soccer.SoccerRecord;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterWrapper;
import jayeson.model.filter.FilterableEvent;

public class FilterableSoccerEvent
extends FilterableEvent<SoccerRecord>
implements SoccerEvent,
IFilterWrapper {
    final SoccerEvent soccerEvent;
    final IDataFilter filter;
    final ISnapshot<?> snapshot;
    private Collection<SoccerRecord> cachedRecords;
    private Collection<SoccerRecord> cachedNotPassedRecords;

    public FilterableSoccerEvent(SoccerEvent event, IDataFilter filter, ISnapshot<?> snapshot) {
        this.soccerEvent = event;
        this.filter = filter;
        this.snapshot = snapshot;
    }

    public Collection<SoccerRecord> records() {
        return this.applyFilter(this.soccerEvent.records());
    }

    @Override
    public Collection<SoccerRecord> unRecords() {
        return this.applyFilter(this.soccerEvent.records(), true);
    }

    Collection<SoccerRecord> applyFilter(Collection<SoccerRecord> records) {
        return this.applyFilter(records, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<SoccerRecord> applyFilter(Collection<SoccerRecord> records, boolean isNegated) {
        if (!isNegated && this.cachedRecords != null) {
            return this.cachedRecords;
        }
        if (isNegated && this.cachedNotPassedRecords != null) {
            return this.cachedNotPassedRecords;
        }
        if (records == null) {
            this.cachedRecords = Arrays.asList(new SoccerRecord[0]);
            this.cachedNotPassedRecords = this.cachedRecords;
            return this.cachedRecords;
        }
        FilterableSoccerEvent filterableSoccerEvent = this;
        synchronized (filterableSoccerEvent) {
            if (this.cachedRecords == null || this.cachedNotPassedRecords == null) {
                ArrayList<SoccerRecord> results = new ArrayList<SoccerRecord>();
                ArrayList<SoccerRecord> notPassedResults = new ArrayList<SoccerRecord>();
                for (SoccerRecord record : records) {
                    if (this.filter.isPassed((IBetRecord)record, this.snapshot)) {
                        results.add(record);
                        continue;
                    }
                    notPassedResults.add(record);
                }
                this.cachedRecords = Collections.unmodifiableList(results);
                this.cachedNotPassedRecords = Collections.unmodifiableList(notPassedResults);
            }
        }
        if (!isNegated) {
            return this.cachedRecords;
        }
        return this.cachedNotPassedRecords;
    }

    @Override
    public IDataFilter getFilter() {
        return this.filter;
    }

    public String id() {
        return this.soccerEvent.id();
    }

    public String matchId() {
        return this.soccerEvent.matchId();
    }

    public Map<String, String> meta() {
        return this.soccerEvent.meta();
    }

    public SoccerEventState eventState() {
        return this.soccerEvent.eventState();
    }

    public Collection<SoccerEventState> eventStates() {
        return this.soccerEvent.eventStates();
    }

    public SoccerEventType eventType() {
        return this.soccerEvent.eventType();
    }

    public boolean isNeutral() {
        return this.soccerEvent.isNeutral();
    }

    public IBetEventState getEventState(String sportbook) {
        return this.soccerEvent.getEventState(sportbook);
    }
}

