/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filter.tennis;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.feed.tennis.TennisEvent;
import jayeson.lib.feed.tennis.TennisGender;
import jayeson.lib.feed.tennis.TennisMatch;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterWrapper;
import jayeson.model.filter.FilterableMatch;
import jayeson.model.filter.tennis.FilterableTennisEvent;

public class FilterableTennisMatch
extends FilterableMatch<TennisEvent>
implements TennisMatch,
IFilterWrapper {
    final TennisMatch tennisMatch;
    final IDataFilter filter;
    final ISnapshot<?> snapshot;
    private Collection<TennisEvent> cachedEvents;
    private Collection<TennisEvent> cachedNotPassedEvents;

    public FilterableTennisMatch(TennisMatch match, IDataFilter filter, ISnapshot<?> snapshot) {
        this.filter = filter;
        this.tennisMatch = match;
        this.snapshot = snapshot;
    }

    public Collection<TennisEvent> events() {
        return this.applyFilter(this.tennisMatch.events());
    }

    @Override
    public Collection<TennisEvent> unEvents() {
        return this.applyFilter(this.tennisMatch.events(), true);
    }

    Collection<TennisEvent> applyFilter(Collection<TennisEvent> events) {
        return this.applyFilter(events, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<TennisEvent> applyFilter(Collection<TennisEvent> events, boolean isNegated) {
        if (!isNegated && this.cachedEvents != null) {
            return this.cachedEvents;
        }
        if (isNegated && this.cachedNotPassedEvents != null) {
            return this.cachedNotPassedEvents;
        }
        if (events == null) {
            this.cachedEvents = Arrays.asList(new TennisEvent[0]);
            this.cachedNotPassedEvents = this.cachedEvents;
            return this.cachedEvents;
        }
        FilterableTennisMatch filterableTennisMatch = this;
        synchronized (filterableTennisMatch) {
            if (this.cachedEvents == null || this.cachedNotPassedEvents == null) {
                LinkedList<FilterableTennisEvent> results = new LinkedList<FilterableTennisEvent>();
                LinkedList<FilterableTennisEvent> notPassedResults = new LinkedList<FilterableTennisEvent>();
                for (TennisEvent event : events) {
                    FilterableTennisEvent filterableEvent = new FilterableTennisEvent(event, this.filter, this.snapshot);
                    if (this.filter.isPassed((IBetEvent)event, this.snapshot)) {
                        results.add(filterableEvent);
                        continue;
                    }
                    notPassedResults.add(filterableEvent);
                }
                this.cachedEvents = Collections.unmodifiableList(results);
                this.cachedNotPassedEvents = Collections.unmodifiableList(notPassedResults);
            }
        }
        if (!isNegated) {
            return this.cachedEvents;
        }
        return this.cachedNotPassedEvents;
    }

    @Override
    public IDataFilter getFilter() {
        return this.filter;
    }

    public String participantOne() {
        return this.tennisMatch.participantOne();
    }

    public String participantTwo() {
        return this.tennisMatch.participantTwo();
    }

    public String getCountry() {
        return this.tennisMatch.getCountry();
    }

    public String id() {
        return this.tennisMatch.id();
    }

    public String league() {
        return this.tennisMatch.league();
    }

    public List<String> participants() {
        return this.tennisMatch.participants();
    }

    public SportType sportType() {
        return this.tennisMatch.sportType();
    }

    public long startTime() {
        return this.tennisMatch.startTime();
    }

    public Map<String, String> meta() {
        return this.tennisMatch.meta();
    }

    public String competition() {
        return this.tennisMatch.competition();
    }

    public TennisGender gender() {
        return this.tennisMatch.gender();
    }

    public String playerOne() {
        return this.tennisMatch.playerOne();
    }

    public String playerTwo() {
        return this.tennisMatch.playerTwo();
    }
}

