/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.model.IDataFilterRule;
import jayeson.model.IMatchFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class ExactLeagueFilterRule
extends GeneralDataFilterRule
implements IMatchFilterRule {
    private Set<String> includeLeagues = new HashSet<String>();

    public ExactLeagueFilterRule() {
        this.ruleType = 18;
    }

    @Override
    public boolean isComplied(IBetMatch match) {
        if (this.includeLeagues.isEmpty()) {
            return true;
        }
        return this.includeLeagues.contains(match.league());
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof ExactLeagueFilterRule) {
            ExactLeagueFilterRule rule = (ExactLeagueFilterRule)o;
            if (this.includeLeagues.size() != rule.getIncludeLeagues().size()) {
                return -1;
            }
            HashSet<String> thisSet = new HashSet<String>(this.includeLeagues);
            HashSet<String> otherSet = new HashSet<String>(rule.getIncludeLeagues());
            for (String test : this.includeLeagues) {
                if (!otherSet.contains(test)) continue;
                thisSet.remove(test);
                otherSet.remove(test);
            }
            if (thisSet.isEmpty() && otherSet.isEmpty()) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (result == 0) {
            if (this.includeLeagues == null || this.includeLeagues.isEmpty()) {
                result = 31 * result;
            } else {
                TreeSet<String> inKeywords = new TreeSet<String>();
                inKeywords.addAll(this.includeLeagues);
                for (String keywords : inKeywords) {
                    result = 31 * result + keywords.hashCode();
                }
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }

    public Set<String> getIncludeLeagues() {
        return this.includeLeagues;
    }

    public void setIncludeLeagues(Set<String> includeLeagues) {
        this.includeLeagues = includeLeagues;
    }
}

