/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jayeson.model.IDataFilterRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public abstract class GeneralDataFilterRule {
    protected Logger logger = LoggerFactory.getLogger(GeneralDataFilterRule.class);
    protected boolean negated;
    protected int ruleType;
    @JsonIgnore
    protected volatile int hashCode;

    public GeneralDataFilterRule() {
        this.negated = false;
    }

    public GeneralDataFilterRule(GeneralDataFilterRule rule) {
        this.negated = rule.negated;
        this.ruleType = rule.ruleType;
    }

    public void setNegated(boolean negated) {
        this.negated = negated;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int compareTo(IDataFilterRule o) {
        if (o instanceof GeneralDataFilterRule) {
            GeneralDataFilterRule rule = (GeneralDataFilterRule)((Object)o);
            if (this.isNegated() != rule.isNegated()) {
                return -1;
            }
            if (this.ruleType != rule.ruleType) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            result = 17;
            result = 31 * result + (this.negated ? 1 : 0);
            result = 31 * result + this.ruleType;
            this.hashCode = result = this.buildHashCode(result);
        }
        return result;
    }

    public abstract int buildHashCode(int var1);

    public int getRuleType() {
        return this.ruleType;
    }
}

