/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.model.IDataFilterRule;
import jayeson.model.IMatchFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class MatchAutoInclusionFilterRule
extends GeneralDataFilterRule
implements IMatchFilterRule {
    private static final long serialVersionUID = -6109547258819032113L;
    private Set<Integer> leagues = new HashSet<Integer>();
    private Set<String> matchIds = new HashSet<String>();

    public MatchAutoInclusionFilterRule() {
        this.ruleType = 29;
    }

    @Override
    public boolean isComplied(IBetMatch match) {
        if (this.matchIds.contains(match.id())) {
            return true;
        }
        int leagueHashCode = match.league().hashCode();
        return this.leagues.contains(leagueHashCode);
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        TreeSet<Integer> leaguesTreeSet = new TreeSet<Integer>();
        leaguesTreeSet.addAll(this.leagues);
        Iterator iterator = leaguesTreeSet.iterator();
        while (iterator.hasNext()) {
            int league = (Integer)iterator.next();
            result = 31 * result + league;
        }
        TreeSet<String> matchIdsTreeSet = new TreeSet<String>();
        matchIdsTreeSet.addAll(this.matchIds);
        for (String matchId : matchIdsTreeSet) {
            result = 31 * result + matchId.hashCode();
        }
        return result;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof MatchAutoInclusionFilterRule) {
            MatchAutoInclusionFilterRule rule = (MatchAutoInclusionFilterRule)o;
            if (!this.leagues.equals(rule.getLeagues())) {
                return -1;
            }
            if (!this.matchIds.equals(rule.getMatchIds())) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }

    public Set<Integer> getLeagues() {
        return this.leagues;
    }

    public void setLeagues(Set<Integer> leagues) {
        this.leagues = leagues;
    }

    public Set<String> getMatchIds() {
        return this.matchIds;
    }

    public void setMatchIds(Set<String> matchId) {
        this.matchIds = matchId;
    }
}

