/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.SportType;
import jayeson.model.IDataFilterRule;
import jayeson.model.IMatchFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class SportFilterRule
extends GeneralDataFilterRule
implements IMatchFilterRule {
    private List<SportType> sportTypes;

    public SportFilterRule() {
        this(Arrays.asList(new SportType[0]));
    }

    public SportFilterRule(List<SportType> sportTypes) {
        this.sportTypes = new ArrayList<SportType>(sportTypes);
        this.ruleType = 22;
    }

    @Override
    public boolean isComplied(IBetMatch match) {
        return this.sportTypes.contains(match.sportType());
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (this.sportTypes == null || this.sportTypes.isEmpty()) {
            result = 31 * result;
        } else {
            TreeSet<SportType> sTypes = new TreeSet<SportType>();
            sTypes.addAll(this.sportTypes);
            for (SportType type : sTypes) {
                result = 31 * result + type.hashCode();
            }
        }
        return result;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof SportFilterRule) {
            SportFilterRule rule = (SportFilterRule)o;
            if (this.getSportTypes().size() != rule.getSportTypes().size()) {
                return -1;
            }
            for (SportType sportType : this.sportTypes) {
                if (rule.getSportTypes().contains(sportType)) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public List<SportType> getSportTypes() {
        return this.sportTypes;
    }

    public void setSportTypes(List<SportType> sportTypes) {
        this.sportTypes = sportTypes;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

