/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.model.IDataFilterRule;
import jayeson.model.IMatchFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class StartTimeRangeFilterRule
extends GeneralDataFilterRule
implements IMatchFilterRule {
    private static Logger log = LoggerFactory.getLogger(StartTimeRangeFilterRule.class);
    private long startTimeLower = 0L;
    private long startTimeUpper = 0L;

    public StartTimeRangeFilterRule() {
        this.ruleType = 16;
    }

    @Override
    private boolean isComplied(long startTime) {
        log.debug("{}-{}-{}", new Object[]{this.startTimeLower, this.startTimeUpper, startTime});
        return this.inRange(this.startTimeLower, this.startTimeUpper, startTime);
    }

    @Override
    public boolean isComplied(IBetMatch match) {
        long startTime = match.startTime();
        return this.isComplied(startTime);
    }

    protected boolean inRange(long lower, long upper, long num) {
        return lower <= num && upper >= num;
    }

    public long getStartTimeLower() {
        return this.startTimeLower;
    }

    public long getStartTimeUpper() {
        return this.startTimeUpper;
    }

    public void setStartTimeLower(long startTimeLower) {
        this.startTimeLower = startTimeLower;
    }

    public void setStartTimeUpper(long startTimeUpper) {
        this.startTimeUpper = startTimeUpper;
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof StartTimeRangeFilterRule) {
            StartTimeRangeFilterRule rule = (StartTimeRangeFilterRule)o;
            if (this.getStartTimeLower() != rule.getStartTimeLower()) {
                return -1;
            }
            if (this.getStartTimeUpper() != rule.getStartTimeUpper()) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        result = 31 * result + (int)(this.startTimeLower ^ this.startTimeLower >>> 32);
        result = 31 * result + (int)(this.startTimeUpper ^ this.startTimeUpper >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

