/*
 * Decompiled with CFR 0.152.
 */
package jayeson.model.filterrules;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.model.IDataFilterRule;
import jayeson.model.IMatchFilterRule;
import jayeson.model.filterrules.GeneralDataFilterRule;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="__c__")
public class TeamKeywordFilterRule
extends GeneralDataFilterRule
implements IMatchFilterRule {
    private Collection<String> includeKeywords = new HashSet<String>();
    private Collection<String> excludeKeywords = new HashSet<String>();

    public TeamKeywordFilterRule() {
        this.ruleType = 9;
    }

    private boolean passedFilter(String input) {
        input = input.toLowerCase();
        for (String keyword : this.excludeKeywords) {
            if (!input.contains(keyword.toLowerCase()) || keyword.length() <= 0) continue;
            return false;
        }
        if (this.includeKeywords.isEmpty()) {
            return true;
        }
        for (String keyword : this.includeKeywords) {
            if (keyword.length() == 0) {
                return true;
            }
            if (!input.contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isComplied(IBetMatch match) {
        String input = String.join((CharSequence)" - ", match.participants());
        return this.passedFilter(input);
    }

    public Collection<String> getIncludeKeywords() {
        return this.includeKeywords;
    }

    public void setIncludeKeywords(Collection<String> includeKeywords) {
        this.includeKeywords.clear();
        for (String item : includeKeywords) {
            this.includeKeywords.add(item.toLowerCase());
        }
    }

    public Collection<String> getExcludeKeywords() {
        return this.excludeKeywords;
    }

    public void setExcludeKeywords(Collection<String> excludeKeywords) {
        this.excludeKeywords.clear();
        for (String item : excludeKeywords) {
            this.excludeKeywords.add(item.toLowerCase());
        }
    }

    @Override
    public int compareTo(IDataFilterRule o) {
        int result = super.compareTo(o);
        if (result == -1) {
            return result;
        }
        if (o instanceof TeamKeywordFilterRule) {
            boolean notFound;
            TeamKeywordFilterRule rule = (TeamKeywordFilterRule)o;
            if (this.includeKeywords.size() != rule.getIncludeKeywords().size()) {
                return -1;
            }
            for (String curKeywords : this.includeKeywords) {
                notFound = true;
                for (String comKeywords : rule.getIncludeKeywords()) {
                    if (!curKeywords.equals(comKeywords)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return -1;
            }
            if (this.excludeKeywords.size() != rule.getExcludeKeywords().size()) {
                return -1;
            }
            for (String curKeywords : this.excludeKeywords) {
                notFound = true;
                for (String comKeywords : rule.getExcludeKeywords()) {
                    if (!curKeywords.equals(comKeywords)) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                return -1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public int buildHashCode(int initialHashCode) {
        int result = initialHashCode;
        if (result == 0) {
            if (this.includeKeywords == null || this.includeKeywords.isEmpty()) {
                result = 31 * result;
            } else {
                TreeSet<String> inKeywords = new TreeSet<String>();
                inKeywords.addAll(this.includeKeywords);
                for (String keywords : inKeywords) {
                    result = 31 * result + keywords.hashCode();
                }
            }
            if (this.excludeKeywords == null || this.excludeKeywords.isEmpty()) {
                result = 31 * result;
            } else {
                TreeSet<String> exKeywords = new TreeSet<String>();
                exKeywords.addAll(this.excludeKeywords);
                for (String keywords : exKeywords) {
                    result = 31 * result + keywords.hashCode();
                }
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IDataFilterRule) {
            return this.compareTo((IDataFilterRule)obj) == 0;
        }
        return false;
    }
}

