/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.SimpleDnsCache;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Never$;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.DnsClient;
import akka.io.dns.internal.package$CachePolicyIsOrdered$;
import akka.pattern.AskTimeoutException;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.PrettyDuration$;
import akka.util.PrettyDuration$PrettyPrintableDuration$;
import akka.util.Timeout;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\r\u0015a!B\u001d;\u0005y\u0012\u0005\u0002\u0003*\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u0011a\u0003!\u0011!Q\u0001\neC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0018\u0005\u0006y\u0002!\t! \u0005\n\u0003\u000f\u0001!\u0019!C\u0002\u0003\u0013A\u0001\"a\u0006\u0001A\u0003%\u00111\u0002\u0005\n\u00033\u0001!\u0019!C\u0002\u00037A\u0001\"!\u000b\u0001A\u0003%\u0011Q\u0004\u0005\n\u0003W\u0001!\u0019!C\u0001\u0003[Aq!a\f\u0001A\u0003%A\rC\u0005\u00022\u0001\u0011\r\u0011\"\u0001\u00024!A\u0011q\n\u0001!\u0002\u0013\t)\u0004C\u0005\u0002R\u0001\u0011\r\u0011\"\u0001\u00024!A\u00111\u000b\u0001!\u0002\u0013\t)\u0004C\u0005\u0002V\u0001\u0001\r\u0011\"\u0003\u0002X!I\u0011q\f\u0001A\u0002\u0013%\u0011\u0011\r\u0005\t\u0003[\u0002\u0001\u0015)\u0003\u0002Z!9\u0011q\u000e\u0001\u0005\n\u0005E\u0004\"CA:\u0001\t\u0007I\u0011BA;\u0011\u001d\t9\b\u0001Q\u0001\naDq!!\u001f\u0001\t\u0003\nY\bC\u0004\u0002\u0006\u0002!I!a\"\t\u000f\u0005}\u0006\u0001\"\u0003\u0002B\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0003{\u0004A\u0011BA\u0000\u000f!\u0011)B\u000fE\u0001}\t]aaB\u001d;\u0011\u0003q$\u0011\u0004\u0005\u0007yr!\tAa\u0007\t\u0013\tuAD1A\u0005\n\t}\u0001\u0002\u0003B\u00189\u0001\u0006IA!\t\t\u0013\tEBD1A\u0005\n\t}\u0001\u0002\u0003B\u001a9\u0001\u0006IA!\t\t\u000f\tUB\u0004\"\u0003\u00038!I!\u0011\t\u000fC\u0002\u0013%!1\t\u0005\t\u0005\u000bb\u0002\u0015!\u0003\u0002D\u001a1!q\t\u000fA\u0005\u0013B!B!\u0018&\u0005+\u0007I\u0011\u0001B0\u0011)\u0011\t'\nB\tB\u0003%\u0011\u0011\u0015\u0005\u0007y\u0016\"\tAa\u0019\t\u0013\t-T%!A\u0005\u0002\t5\u0004\"\u0003B9KE\u0005I\u0011\u0001B:\u0011%\u00119)JA\u0001\n\u0003\u0012I\tC\u0005\u0003\u0016\u0016\n\t\u0011\"\u0001\u0003\u0018\"I!qT\u0013\u0002\u0002\u0013\u0005!\u0011\u0015\u0005\n\u0005W+\u0013\u0011!C!\u0005[C\u0011Ba/&\u0003\u0003%\tA!0\t\u0013\t\u0005W%!A\u0005B\t\r\u0007\"\u0003BcK\u0005\u0005I\u0011\tBd\u000f%\u0011Y\rHA\u0001\u0012\u0003\u0011iMB\u0005\u0003Hq\t\t\u0011#\u0001\u0003P\"1Ap\rC\u0001\u0005;D\u0011Ba84\u0003\u0003%)E!9\t\u0013\t\r8'!A\u0005\u0002\n\u0015\b\"\u0003Bug\u0005\u0005I\u0011\u0011Bv\u0011%\u00119pMA\u0001\n\u0013\u0011IP\u0001\tBgft7\r\u00128t%\u0016\u001cx\u000e\u001c<fe*\u00111\bP\u0001\tS:$XM\u001d8bY*\u0011QHP\u0001\u0004I:\u001c(BA A\u0003\tIwNC\u0001B\u0003\u0011\t7n[1\u0014\t\u0001\u0019\u0015j\u0014\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0007\u0003:L(+\u001a4\u0011\u0005)kU\"A&\u000b\u00051\u0003\u0015!B1di>\u0014\u0018B\u0001(L\u0005\u0015\t5\r^8s!\tQ\u0005+\u0003\u0002R\u0017\na\u0011i\u0019;pe2{wmZ5oO\u0006A1/\u001a;uS:<7o\u0001\u0001\u0011\u0005U3V\"\u0001\u001f\n\u0005]c$a\u0003#ogN+G\u000f^5oON\fQaY1dQ\u0016\u0004\"AW.\u000e\u0003yJ!\u0001\u0018 \u0003\u001dMKW\u000e\u001d7f\t:\u001c8)Y2iK\u0006i1\r\\5f]R4\u0015m\u0019;pef\u0004R\u0001R0bIbL!\u0001Y#\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001&c\u0013\t\u00197JA\bBGR|'OU3g\r\u0006\u001cGo\u001c:z!\r)W\u000e\u001d\b\u0003M.t!a\u001a6\u000e\u0003!T!![*\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0015B\u00017F\u0003\u001d\u0001\u0018mY6bO\u0016L!A\\8\u0003\t1K7\u000f\u001e\u0006\u0003Y\u0016\u0003\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\u00079,GOC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]\u0014(!E%oKR\u001cvnY6fi\u0006#GM]3tgB\u0019Q-\\=\u0011\u0005)S\u0018BA>L\u0005!\t5\r^8s%\u00164\u0017A\u0002\u001fj]&$h\bF\u0004\u007f\u0003\u0003\t\u0019!!\u0002\u0011\u0005}\u0004Q\"\u0001\u001e\t\u000bI#\u0001\u0019\u0001+\t\u000ba#\u0001\u0019A-\t\u000bu#\u0001\u0019\u00010\u0002\u0005\u0015\u001cWCAA\u0006!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\u000b\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005U\u0011q\u0002\u0002\u0019\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u0014\u0018aA3dA\u00059A/[7f_V$XCAA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012\u0001\u0006!Q\u000f^5m\u0013\u0011\t9#!\t\u0003\u000fQKW.Z8vi\u0006AA/[7f_V$\b%A\u0006oC6,7+\u001a:wKJ\u001cX#\u00013\u0002\u00199\fW.Z*feZ,'o\u001d\u0011\u0002'A|7/\u001b;jm\u0016\u001c\u0015m\u00195f!>d\u0017nY=\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u0013rA!!\u000f\u0002F9!\u00111HA\"\u001d\u0011\ti$!\u0011\u000f\u0007\u001d\fy$C\u0001B\u0013\ty\u0004)\u0003\u0002>}%\u0019\u0011q\t\u001f\u0002\u0017\r\u000b7\r[3Q_2L7-_\u0005\u0005\u0003\u0017\niEA\u0006DC\u000eDW\rU8mS\u000eL(bAA$y\u0005!\u0002o\\:ji&4XmQ1dQ\u0016\u0004v\u000e\\5ds\u0002\n1C\\3hCRLg/Z\"bG\",\u0007k\u001c7jGf\fAC\\3hCRLg/Z\"bG\",\u0007k\u001c7jGf\u0004\u0013!\u0003:fcV,7\u000f^%e+\t\tI\u0006E\u0002E\u00037J1!!\u0018F\u0005\u0015\u0019\u0006n\u001c:u\u00035\u0011X-];fgRLEm\u0018\u0013fcR!\u00111MA5!\r!\u0015QM\u0005\u0004\u0003O*%\u0001B+oSRD\u0011\"a\u001b\u0011\u0003\u0003\u0005\r!!\u0017\u0002\u0007a$\u0013'\u0001\u0006sKF,Xm\u001d;JI\u0002\naA\\3yi&#GCAA-\u0003%\u0011Xm]8mm\u0016\u00148/F\u0001y\u0003)\u0011Xm]8mm\u0016\u00148\u000fI\u0001\be\u0016\u001cW-\u001b<f+\t\ti\b\u0005\u0003\u0002\u0000\u0005\u0005U\"\u0001\u0001\n\u0007\u0005\rUJA\u0004SK\u000e,\u0017N^3\u0002)I,7o\u001c7wK^KG\u000f\u001b*fg>dg/\u001a:t)!\tI)!(\u00022\u0006u\u0006CBA\u0007\u0003\u0017\u000by)\u0003\u0003\u0002\u000e\u0006=!A\u0002$viV\u0014X\r\u0005\u0003\u0002\u0012\u0006]ebA+\u0002\u0014&\u0019\u0011Q\u0013\u001f\u0002\u0017\u0011s7\u000f\u0015:pi>\u001cw\u000e\\\u0005\u0005\u00033\u000bYJ\u0001\u0005SKN|GN^3e\u0015\r\t)\n\u0010\u0005\b\u0003?3\u0002\u0019AAQ\u0003\u0011q\u0017-\\3\u0011\t\u0005\r\u00161\u0016\b\u0005\u0003K\u000b9\u000b\u0005\u0002h\u000b&\u0019\u0011\u0011V#\u0002\rA\u0013X\rZ3g\u0013\u0011\ti+a,\u0003\rM#(/\u001b8h\u0015\r\tI+\u0012\u0005\b\u0003g3\u0002\u0019AA[\u0003-\u0011X-];fgR$\u0016\u0010]3\u0011\t\u0005]\u0016\u0011\u0018\b\u0005\u0003s\t\u0019*\u0003\u0003\u0002<\u0006m%a\u0003*fcV,7\u000f\u001e+za\u0016Da!a\u001d\u0017\u0001\u0004A\u0018\u0001D:f]\u0012\fV/Z:uS>tGCBAb\u0003/\fY\u000e\u0005\u0004\u0002\u000e\u0005-\u0015Q\u0019\t\u0005\u0003\u000f\f\tN\u0004\u0003\u0002J\u00065g\u0002BA\u001d\u0003\u0017L!a\u000f\u001f\n\u0007\u0005='(A\u0005E]N\u001cE.[3oi&!\u00111[Ak\u0005\u0019\ten]<fe*\u0019\u0011q\u001a\u001e\t\r\u0005ew\u00031\u0001z\u0003!\u0011Xm]8mm\u0016\u0014\bbBAo/\u0001\u0007\u0011q\\\u0001\b[\u0016\u001c8/Y4f!\u0011\t9-!9\n\t\u0005\r\u0018Q\u001b\u0002\f\t:\u001c\u0018+^3ti&|g.A\tsKN|GN^3XSRD7+Z1sG\"$\u0002\"!#\u0002j\u0006-\u0018Q\u001e\u0005\b\u0003?C\u0002\u0019AAQ\u0011\u001d\t\u0019\f\u0007a\u0001\u0003kCa!!7\u0019\u0001\u0004I\u0018\u0001\u0004:fg>dg/\u001a$jeN$H\u0003CAE\u0003g\fI0a?\t\u000f\u0005U\u0018\u00041\u0001\u0002x\u0006Y1/Z1sG\"t\u0015-\\3t!\u0011)W.!)\t\u000f\u0005M\u0016\u00041\u0001\u00026\"1\u0011\u0011\\\rA\u0002e\fqA]3t_24X\r\u0006\u0005\u0002\n\n\u0005!1\u0001B\u0003\u0011\u001d\tyJ\u0007a\u0001\u0003CCq!a-\u001b\u0001\u0004\t)\f\u0003\u0004\u0002Zj\u0001\r!\u001f\u0015\u0004\u0001\t%\u0001\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\u0007\t=\u0001)\u0001\u0006b]:|G/\u0019;j_:LAAa\u0005\u0003\u000e\tY\u0011J\u001c;fe:\fG.\u00119j\u0003A\t5/\u001f8d\t:\u001c(+Z:pYZ,'\u000f\u0005\u0002\u00009M\u0011Ad\u0011\u000b\u0003\u0005/\t1\"\u001b9wi\u0005#GM]3tgV\u0011!\u0011\u0005\t\u0005\u0005G\u0011Y#\u0004\u0002\u0003&)!!q\u0005B\u0015\u0003!i\u0017\r^2iS:<'bAA\u0012\u000b&!!Q\u0006B\u0013\u0005\u0015\u0011VmZ3y\u00031I\u0007O\u001e\u001bBI\u0012\u0014Xm]:!\u0003-I\u0007O\u001e\u001cBI\u0012\u0014Xm]:\u0002\u0019%\u0004hON!eIJ,7o\u001d\u0011\u0002\u001b%\u001c\u0018J\\3u\u0003\u0012$'/Z:t)\u0011\u0011IDa\u0010\u0011\u0007\u0011\u0013Y$C\u0002\u0003>\u0015\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002 \n\u0002\r!!)\u0002\u000b\u0015k\u0007\u000f^=\u0016\u0005\u0005\r\u0017AB#naRL\bE\u0001\fSKN|GN^3GC&dW\rZ#yG\u0016\u0004H/[8o'\u001d)#1\nB)\u0005/\u00022!\u001aB'\u0013\r\u0011ye\u001c\u0002\n\u000bb\u001cW\r\u001d;j_:\u00042\u0001\u0012B*\u0013\r\u0011)&\u0012\u0002\b!J|G-^2u!\r!%\u0011L\u0005\u0004\u00057*%\u0001D*fe&\fG.\u001b>bE2,\u0017aA7tOV\u0011\u0011\u0011U\u0001\u0005[N<\u0007\u0005\u0006\u0003\u0003f\t%\u0004c\u0001B4K5\tA\u0004C\u0004\u0003^!\u0002\r!!)\u0002\t\r|\u0007/\u001f\u000b\u0005\u0005K\u0012y\u0007C\u0005\u0003^%\u0002\n\u00111\u0001\u0002\"\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B;U\u0011\t\tKa\u001e,\u0005\te\u0004\u0003\u0002B>\u0005\u0007k!A! \u000b\t\t}$\u0011Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0004F\u0013\u0011\u0011)I! \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0017\u0003BA!$\u0003\u00146\u0011!q\u0012\u0006\u0004\u0005##\u0018\u0001\u00027b]\u001eLA!!,\u0003\u0010\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!\u0011\u0014\t\u0004\t\nm\u0015b\u0001BO\u000b\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0015BU!\r!%QU\u0005\u0004\u0005O+%aA!os\"I\u00111N\u0017\u0002\u0002\u0003\u0007!\u0011T\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0016\t\u0007\u0005c\u00139La)\u000e\u0005\tM&b\u0001B[\u000b\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\te&1\u0017\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003:\t}\u0006\"CA6_\u0005\u0005\t\u0019\u0001BR\u0003!A\u0017m\u001d5D_\u0012,GC\u0001BM\u0003\u0019)\u0017/^1mgR!!\u0011\bBe\u0011%\tY'MA\u0001\u0002\u0004\u0011\u0019+\u0001\fSKN|GN^3GC&dW\rZ#yG\u0016\u0004H/[8o!\r\u00119gM\n\u0006g\tE'q\u000b\t\t\u0005'\u0014I.!)\u0003f5\u0011!Q\u001b\u0006\u0004\u0005/,\u0015a\u0002:v]RLW.Z\u0005\u0005\u00057\u0014)NA\tBEN$(/Y2u\rVt7\r^5p]F\"\"A!4\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa#\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\t\t\u0015$q\u001d\u0005\b\u0005;2\u0004\u0019AAQ\u0003\u001d)h.\u00199qYf$BA!<\u0003tB)AIa<\u0002\"&\u0019!\u0011_#\u0003\r=\u0003H/[8o\u0011%\u0011)pNA\u0001\u0002\u0004\u0011)'A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1 \t\u0005\u0005\u001b\u0013i0\u0003\u0003\u0003\u0000\n=%AB(cU\u0016\u001cG\u000fK\u0002\u001d\u0005\u0013A3a\u0007B\u0005\u0001")
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final DnsSettings settings;
    public final SimpleDnsCache akka$io$dns$internal$AsyncDnsResolver$$cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private final CachePolicy.CachePolicy positiveCachePolicy;
    private final CachePolicy.CachePolicy negativeCachePolicy;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    public CachePolicy.CachePolicy positiveCachePolicy() {
        return this.positiveCachePolicy;
    }

    public CachePolicy.CachePolicy negativeCachePolicy() {
        return this.negativeCachePolicy;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.RequestType mode;
                    DnsProtocol.Resolve resolve = (DnsProtocol.Resolve)A1;
                    String name = resolve.name();
                    Option<DnsProtocol.Resolved> option = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.get((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)(mode = resolve.requestType())));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        DnsProtocol.Resolved resolved2 = (DnsProtocol.Resolved)some.value();
                        this.$outer.log().debug("{} cached {}", mode, resolved2);
                        package$.MODULE$.actorRef2Scala(this.$outer.sender()).$bang(resolved2, this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()).map((Function1 & Serializable & scala.Serializable)resolved -> {
                            if (resolved.records().nonEmpty()) {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.positiveCachePolicy();
                                CachePolicy.CachePolicy minTtl = (CachePolicy.CachePolicy)((TraversableOnce)((SeqLike)resolved.records().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.ttl(), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)cachePolicy, Seq$.MODULE$.canBuildFrom())).min((Ordering)package$CachePolicyIsOrdered$.MODULE$);
                                $this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)mode), (DnsProtocol.Resolved)resolved, minTtl);
                            } else {
                                CachePolicy.CachePolicy cachePolicy = $this.$outer.negativeCachePolicy();
                                CachePolicy$Never$ cachePolicy$Never$ = CachePolicy$Never$.MODULE$;
                                if (cachePolicy == null ? cachePolicy$Never$ != null : !cachePolicy.equals(cachePolicy$Never$)) {
                                    $this.$outer.akka$io$dns$internal$AsyncDnsResolver$$cache.put((Tuple2<String, DnsProtocol.RequestType>)new Tuple2((Object)name, (Object)mode), (DnsProtocol.Resolved)resolved, $this.$outer.negativeCachePolicy());
                                }
                            }
                            $this.$outer.log().debug("{} resolved {}", mode, resolved);
                            return resolved;
                        }, (ExecutionContext)this.$outer.ec()), (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(akka.io.dns.internal.AsyncDnsResolver$$anonfun$receive$1 java.lang.String akka.io.dns.DnsProtocol$RequestType akka.io.dns.DnsProtocol$Resolved ), $anonfun$applyOrElse$2(akka.io.dns.ResourceRecord )}, serializedLambda);
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        Future future;
        if (AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) {
            future = Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                ARecord record;
                ResourceRecord resourceRecord;
                InetAddress address = InetAddress.getByName(name);
                InetAddress inetAddress = address;
                if (inetAddress instanceof Inet4Address) {
                    resourceRecord = new ARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                } else if (inetAddress instanceof Inet6Address) {
                    Inet6Address inet6Address = (Inet6Address)inetAddress;
                    resourceRecord = new AAAARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                } else {
                    throw new MatchError((Object)inetAddress);
                }
                ARecord aRecord = record = resourceRecord;
                return DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord));
            }));
        } else {
            Future future2;
            List<ActorRef> list = resolvers;
            if (Nil$.MODULE$.equals(list)) {
                future2 = Future$.MODULE$.failed((Throwable)new ResolveFailedException(new StringBuilder(37).append("Failed to resolve ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                ActorRef head = (ActorRef)colon2.head();
                List tail = colon2.tl$access$1();
                future2 = this.resolveWithSearch(name, requestType, head).recoverWith((PartialFunction)new scala.Serializable(this, name, requestType, tail){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AsyncDnsResolver $outer;
                    private final String name$2;
                    private final DnsProtocol.RequestType requestType$1;
                    private final List tail$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Future<DnsProtocol.Resolved> future;
                        A1 A1 = x1;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            Throwable t = (Throwable)option.get();
                            Throwable throwable = t;
                            if (throwable instanceof AskTimeoutException) {
                                this.$outer.log().info("Resolve of {} timed out after {}. Trying next name server", this.name$2, PrettyDuration$PrettyPrintableDuration$.MODULE$.pretty$extension0(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.$outer.timeout().duration())));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                this.$outer.log().info("Resolve of {} failed. Trying next name server {}", this.name$2, t.getMessage());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            future = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolveWithResolvers(this.name$2, this.requestType$1, (List<ActorRef>)this.tail$1);
                        } else {
                            future = function1.apply(x1);
                        }
                        return (B1)future;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.name$2 = name$2;
                        this.requestType$1 = requestType$1;
                        this.tail$1 = tail$1;
                    }
                }, (ExecutionContext)this.ec());
            } else {
                throw new MatchError(list);
            }
            future = future2;
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result = AskableActorRef$.MODULE$.$qmark$extension1(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result.failed().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            AsyncDnsResolver.$anonfun$sendQuestion$1(this, resolver, message, x$4);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.ec());
        return var3_3;
    }

    private Future<DnsProtocol.Resolved> resolveWithSearch(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future<DnsProtocol.Resolved> future;
        if (this.settings.SearchDomains().nonEmpty()) {
            List list;
            List nameWithSearch = (List)this.settings.SearchDomains().map((Function1 & Serializable & scala.Serializable)sd -> new StringBuilder(1).append(name).append(".").append((String)sd).toString(), List$.MODULE$.canBuildFrom());
            if (new StringOps(Predef$.MODULE$.augmentString(name)).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AsyncDnsResolver.$anonfun$resolveWithSearch$2(BoxesRunTime.unboxToChar((Object)x$5)))) >= this.settings.NDots()) {
                String string = name;
                list = nameWithSearch.$colon$colon((Object)string);
            } else {
                list = (List)nameWithSearch.$colon$plus((Object)name, List$.MODULE$.canBuildFrom());
            }
            List toResolve = list;
            future = this.resolveFirst((List<String>)toResolve, requestType, resolver);
        } else {
            future = this.resolve(name, requestType, resolver);
        }
        return future;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<DnsProtocol.Resolved> resolveFirst(List<String> searchNames, DnsProtocol.RequestType requestType, ActorRef resolver) {
        boolean bl = false;
        .colon.colon colon2 = null;
        List<String> list = searchNames;
        if (list instanceof .colon.colon) {
            bl = true;
            colon2 = (.colon.colon)list;
            String searchName = (String)colon2.head();
            List list2 = colon2.tl$access$1();
            if (Nil$.MODULE$.equals(list2)) {
                return this.resolve(searchName, requestType, resolver);
            }
        }
        if (bl) {
            String searchName = (String)colon2.head();
            List remaining = colon2.tl$access$1();
            return this.resolve(searchName, requestType, resolver).flatMap((Function1 & Serializable & scala.Serializable)resolved -> resolved.records().isEmpty() ? this.resolveFirst((List<String>)remaining, requestType, resolver) : Future$.MODULE$.successful(resolved), (ExecutionContext)this.ec());
        }
        if (!Nil$.MODULE$.equals(list)) throw new MatchError(list);
        return Future$.MODULE$.failed((Throwable)new IllegalStateException("Failed to 'resolveFirst': 'searchNames' must not be empty"));
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future future;
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
            boolean ipv42 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            Future<DnsClient.Answer> ipv4Recs = ipv42 ? this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            Future<DnsClient.Answer> ipv6Recs = ipv6 ? this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName)) : AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            future = ipv4Recs.flatMap((Function1 & Serializable & scala.Serializable)ipv4 -> ipv6Recs.map((Function1 & Serializable & scala.Serializable)ipv6 -> new DnsProtocol.Resolved(name, (Seq<ResourceRecord>)((Seq)ipv4.rrs().$plus$plus(ipv6.rrs(), Seq$.MODULE$.canBuildFrom())), (Seq<ResourceRecord>)((Seq)ipv4.additionalRecs().$plus$plus(ipv6.additionalRecs(), Seq$.MODULE$.canBuildFrom()))), (ExecutionContext)this.ec()), (ExecutionContext)this.ec());
        } else if (DnsProtocol$Srv$.MODULE$.equals(requestType2)) {
            future = this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map((Function1 & Serializable & scala.Serializable)answer -> new DnsProtocol.Resolved(name, answer.rrs(), answer.additionalRecs()), (ExecutionContext)this.ec());
        } else {
            throw new MatchError((Object)requestType2);
        }
        return future;
    }

    public static final /* synthetic */ void $anonfun$sendQuestion$1(AsyncDnsResolver $this, ActorRef resolver$1, DnsClient.DnsQuestion message$1, Throwable x$4) {
        package$.MODULE$.actorRef2Scala(resolver$1).$bang(new DnsClient.DropRequest(message$1.id()), $this.self());
    }

    public static final /* synthetic */ boolean $anonfun$resolveWithSearch$2(char x$5) {
        return x$5 == '.';
    }

    public AsyncDnsResolver(DnsSettings settings, SimpleDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this.settings = settings;
        this.akka$io$dns$internal$AsyncDnsResolver$$cache = cache;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.positiveCachePolicy = settings.PositiveCachePolicy();
        this.negativeCachePolicy = settings.NegativeCachePolicy();
        this.log().debug("Using name servers [{}] and search domains [{}] with ndots={}", this.nameServers(), settings.SearchDomains(), BoxesRunTime.boxToInteger((int)settings.NDots()));
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = (List)clientFactory.apply((Object)this.context(), this.nameServers());
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    scala.Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String productPrefix() {
            return "ResolveFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.msg();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.$init$((Product)this);
        }
    }
}

