/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import akka.util.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.InMemoryBodyWritable;
import play.libs.ws.WSRequestExecutor;
import play.libs.ws.WSRequestFilter;
import play.libs.ws.ahc.StandaloneAhcWSRequest;
import play.shaded.ahc.org.asynchttpclient.Request;
import play.shaded.ahc.org.asynchttpclient.proxy.ProxyServer;
import play.shaded.ahc.org.asynchttpclient.util.HttpUtils;

public class AhcCurlRequestLogger
implements WSRequestFilter {
    private final Logger logger;
    private static final Pattern SINGLE_QUOTE_REPLACE = Pattern.compile("'", 16);

    public AhcCurlRequestLogger(Logger logger) {
        this.logger = logger;
    }

    public AhcCurlRequestLogger() {
        this(LoggerFactory.getLogger(AhcCurlRequestLogger.class));
    }

    public WSRequestExecutor apply(WSRequestExecutor wSRequestExecutor) {
        return standaloneWSRequest -> {
            this.logger.info(this.toCurl((StandaloneAhcWSRequest)standaloneWSRequest));
            return (CompletionStage)wSRequestExecutor.apply(standaloneWSRequest);
        };
    }

    private String toCurl(StandaloneAhcWSRequest standaloneAhcWSRequest) {
        StringBuilder stringBuilder = new StringBuilder("curl \\\n");
        stringBuilder.append("  --verbose").append(" \\\n");
        stringBuilder.append("  --request ").append(standaloneAhcWSRequest.getMethod()).append(" \\\n");
        standaloneAhcWSRequest.getAuth().ifPresent(wSAuthInfo -> {
            String string = Base64.getUrlEncoder().encodeToString((wSAuthInfo.getUsername() + ':' + wSAuthInfo.getPassword()).getBytes(StandardCharsets.US_ASCII));
            stringBuilder.append("  --header 'Authorization: Basic ").append(AhcCurlRequestLogger.quote(string)).append('\'').append(" \\\n");
        });
        standaloneAhcWSRequest.getHeaders().forEach((string, list) -> list.forEach(string2 -> stringBuilder.append("  --header '").append(AhcCurlRequestLogger.quote(string)).append(": ").append(AhcCurlRequestLogger.quote(string2)).append('\'').append(" \\\n")));
        standaloneAhcWSRequest.getCookies().forEach(wSCookie -> stringBuilder.append("  --cookie '").append(wSCookie.getName()).append('=').append(wSCookie.getValue()).append('\'').append(" \\\n"));
        standaloneAhcWSRequest.getBody().ifPresent(bodyWritable -> {
            if (!(bodyWritable instanceof InMemoryBodyWritable)) {
                throw new UnsupportedOperationException("Unsupported body type " + bodyWritable.getClass());
            }
            InMemoryBodyWritable inMemoryBodyWritable = (InMemoryBodyWritable)bodyWritable;
            String string = AhcCurlRequestLogger.findCharset(standaloneAhcWSRequest);
            String string2 = ((ByteString)inMemoryBodyWritable.body().get()).decodeString(string);
            stringBuilder.append("  --data '").append(AhcCurlRequestLogger.quote(string2)).append('\'').append(" \\\n");
        });
        Request request = standaloneAhcWSRequest.buildRequest();
        ProxyServer proxyServer = request.getProxyServer();
        if (proxyServer != null) {
            stringBuilder.append("  --proxy ").append(proxyServer.getHost()).append(':').append(proxyServer.getPort()).append(" \\\n");
        }
        stringBuilder.append("  '").append(AhcCurlRequestLogger.quote(request.getUrl())).append('\'');
        return stringBuilder.toString();
    }

    private static String findCharset(StandaloneAhcWSRequest standaloneAhcWSRequest) {
        return Optional.ofNullable(standaloneAhcWSRequest.getContentType()).flatMap(optional -> optional.map(HttpUtils::extractContentTypeCharsetAttribute)).orElse(StandardCharsets.UTF_8).name();
    }

    private static String quote(String string) {
        return SINGLE_QUOTE_REPLACE.matcher(string).replaceAll(Matcher.quoteReplacement("'\\''"));
    }
}

