/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import jayeson.lib.streamfinder.StreamfinderConfig;
import jayeson.lib.streamfinder.internal.AdvertChannel;
import jayeson.lib.streamfinder.internal.AdvertSnapshot;
import jayeson.lib.streamfinder.internal.Advertisement;
import jayeson.lib.streamfinder.internal.StreamJson;
import jayeson.lib.streamfinder.internal.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Advertiser {
    final String serviceId;
    final String scope;
    AdvertSnapshot currAdvert;
    final AdvertChannel adSender;
    final Object lock;
    static final Logger log = LoggerFactory.getLogger(Advertiser.class);

    public Advertiser(StreamfinderConfig config, String scope, AdvertChannel adSender) {
        this.serviceId = config.getServiceId();
        this.scope = scope;
        this.currAdvert = new AdvertSnapshot(this.serviceId, scope);
        this.adSender = adSender;
        adSender.setCurrentAdvert(this.currAdvert);
        this.lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Advertiser advertise(byte group, String stream, int level) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream names cannot be null");
        }
        if (level < 0) {
            throw new IllegalArgumentException("Level cannot be less than 0");
        }
        Object object = this.lock;
        synchronized (object) {
            Advertisement ad = new Advertisement(this.currAdvert.getStreams());
            ad = ad.advertise(Utils.serializeByte(group), stream, level);
            this.currAdvert = this.currAdvert.setStreams(ad.getAdvertisements());
        }
        this.send(this.currAdvert);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte group) {
        Object object = this.lock;
        synchronized (object) {
            Advertisement ad = new Advertisement(this.currAdvert.getStreams());
            ad = ad.remove(Utils.serializeByte(group));
            this.currAdvert = this.currAdvert.setStreams(ad.getAdvertisements());
        }
        this.send(this.currAdvert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(byte group, String stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream names cannot be null");
        }
        Object object = this.lock;
        synchronized (object) {
            Advertisement ad = new Advertisement(this.currAdvert.getStreams());
            ad = ad.remove(Utils.serializeByte(group), stream);
            this.currAdvert = this.currAdvert.setStreams(ad.getAdvertisements());
        }
        this.send(this.currAdvert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Advertiser from(String url) {
        URI location = Utils.parseUri(url);
        Object object = this.lock;
        synchronized (object) {
            Collection<URI> newConns = this.currAdvert.getConnections();
            newConns.add(location);
            this.currAdvert = this.currAdvert.setConnections(newConns);
        }
        this.send(this.currAdvert);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Advertiser removeUri(String url) {
        URI location = Utils.parseUri(url);
        Object object = this.lock;
        synchronized (object) {
            Collection<URI> newConns = this.currAdvert.getConnections();
            newConns.remove(location);
            this.currAdvert = this.currAdvert.setConnections(newConns);
        }
        this.send(this.currAdvert);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            AdvertSnapshot updatedAds = this.currAdvert.setStreams(new ArrayList<StreamJson>());
            this.currAdvert = updatedAds = updatedAds.setConnections(new ArrayList<URI>());
        }
        this.send(this.currAdvert);
    }

    public String getScope() {
        return this.scope;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    @Deprecated
    public Advertiser onConnected(Consumer<String> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        return this;
    }

    @Deprecated
    public Advertiser onDisconnected(Consumer<String> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        return this;
    }

    @Deprecated
    public Advertiser onError(Consumer<Throwable> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        return this;
    }

    @Deprecated
    public Advertiser onUpdate(Runnable handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        return this;
    }

    @Deprecated
    public synchronized boolean isStarted() {
        return true;
    }

    @Deprecated
    public synchronized void start() {
    }

    @Deprecated
    public synchronized void shutdown() {
    }

    void send(AdvertSnapshot request) {
        this.adSender.setCurrentAdvert(request);
    }

    public void setConnected(boolean value) {
        this.adSender.setConnected(value);
    }
}

