/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import jayeson.lib.streamfinder.AuthenticationException;
import jayeson.lib.streamfinder.SessionFactory;
import jayeson.lib.streamfinder.SessionToken;
import jayeson.lib.streamfinder.Source;
import jayeson.lib.streamfinder.StreamfinderConfig;
import jayeson.lib.streamfinder.internal.DiscoveryClient;
import jayeson.lib.streamfinder.internal.SourceJson;
import jayeson.lib.streamfinder.internal.StreamJson;
import jayeson.lib.streamfinder.internal.Utils;
import jayeson.utility.JacksonConfig;
import jayeson.utility.JacksonConfigFormat;
import play.libs.ws.StandaloneWSClient;
import play.libs.ws.StandaloneWSResponse;

public class Discoverer {
    Set<Source> currentSources;
    final List<String> allowedProtocols = new ArrayList<String>();
    final List<String> exclusions = new ArrayList<String>();
    final DiscoveryClient discoveryClient;
    final AtomicBoolean isLoggedIn;
    final List<Consumer<String>> connectListeners;
    final List<Consumer<String>> disconnectListeners;
    final List<Consumer<List<Source>>> updateListeners;
    final List<Consumer<Throwable>> errorListeners;
    final String scope;
    boolean started;
    CompletionStage<Set<Source>> lastRequest;
    long discoverRetryMs;
    final StandaloneWSClient httpClient;
    static final Duration HTTP_TIMEOUT = Duration.ofMinutes(5L);

    @AssistedInject
    public Discoverer(@Assisted StreamfinderConfig config, @Named(value="SF_HTTP_CLIENT") StandaloneWSClient httpClient, SessionFactory sessionFactory) {
        this(config, httpClient, sessionFactory, null);
    }

    @AssistedInject
    public Discoverer(@Assisted StreamfinderConfig config, @Named(value="SF_HTTP_CLIENT") StandaloneWSClient httpClient, SessionFactory sessionFactory, @Assisted(value="scope") String scope) {
        this.discoveryClient = new DiscoveryClient(config.getUsername(), config.getPassword(), config.getDiscoveryUri(), httpClient, sessionFactory);
        this.connectListeners = new CopyOnWriteArrayList<Consumer<String>>();
        this.disconnectListeners = new CopyOnWriteArrayList<Consumer<String>>();
        this.errorListeners = new CopyOnWriteArrayList<Consumer<Throwable>>();
        this.updateListeners = new CopyOnWriteArrayList<Consumer<List<Source>>>();
        this.isLoggedIn = new AtomicBoolean(false);
        this.lastRequest = null;
        this.currentSources = new HashSet<Source>();
        this.started = false;
        this.discoverRetryMs = config.getDiscoverRetryMs();
        this.httpClient = httpClient;
        this.scope = config.isDiscoverByScope() ? scope : null;
    }

    @AssistedInject
    public Discoverer(@Assisted(value="username") String username, @Assisted(value="password") String password, @Assisted(value="discoveryUrl") String discoveryUrl, @Assisted(value="pollRateS") long pollRateS, @Named(value="SF_HTTP_CLIENT") StandaloneWSClient httpClient, SessionFactory sessionFactory) {
        this(new StreamfinderConfig(username, password, discoveryUrl, ""), httpClient, sessionFactory, null);
    }

    @AssistedInject
    public Discoverer(@Assisted(value="username") String username, @Assisted(value="password") String password, @Assisted(value="discoveryUrl") String discoveryUrl, @Assisted(value="scope") String scope, @Assisted(value="pollRateS") long pollRateS, @Named(value="SF_HTTP_CLIENT") StandaloneWSClient httpClient, SessionFactory sessionFactory) {
        this(new StreamfinderConfig(username, password, discoveryUrl, "", true), httpClient, sessionFactory, scope);
    }

    @AssistedInject
    public Discoverer(@Assisted(value="username") String username, @Assisted(value="password") String password, @Assisted(value="discoveryUrl") String discoveryUrl, @Named(value="SF_HTTP_CLIENT") StandaloneWSClient httpClient, SessionFactory sessionFactory) {
        this(username, password, discoveryUrl, 0L, httpClient, sessionFactory);
    }

    @AssistedInject
    public Discoverer(@Assisted(value="username") String username, @Assisted(value="password") String password, @Assisted(value="discoveryUrl") String discoveryUrl, @Assisted(value="scope") String scope, @Named(value="SF_HTTP_CLIENT") StandaloneWSClient httpClient, SessionFactory sessionFactory) {
        this(username, password, discoveryUrl, scope, 0L, httpClient, sessionFactory);
    }

    @AssistedInject
    public Discoverer(@Assisted String file, @Named(value="SF_HTTP_CLIENT") StandaloneWSClient httpClient, SessionFactory sessionFactory) {
        this(Discoverer.config(file), httpClient, sessionFactory, null);
    }

    public Discoverer onConnected(Consumer<String> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        this.connectListeners.add(handler);
        return this;
    }

    public Discoverer onDisconnected(Consumer<String> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        this.disconnectListeners.add(handler);
        return this;
    }

    public Discoverer onError(Consumer<Throwable> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        this.errorListeners.add(handler);
        return this;
    }

    public Discoverer onUpdate(Consumer<List<Source>> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler cannot be null");
        }
        this.updateListeners.add(handler);
        return this;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public synchronized void start() {
        this.emitUpdate(this.currentSources);
        if (this.isStarted()) {
            return;
        }
        this.started = true;
        this.doRequest();
    }

    public synchronized void shutdown() throws IOException {
        this.lastRequest = null;
        this.started = false;
        this.setCurrentSources(new HashSet<Source>());
        this.httpClient.close();
    }

    CompletionStage<Void> update() {
        if (this.isStarted()) {
            return this.doRequest();
        }
        return CompletableFuture.completedFuture(null);
    }

    synchronized CompletionStage<Void> doRequest() {
        CompletionStage request = this.discoveryClient.doLogin().exceptionally(this::handleNetworkError).thenApply(this::monitorAuthentication).thenCompose(this::doQuery);
        this.lastRequest = request;
        return request.thenAccept(src -> this.setSourceIfLatest(request, (Set<Source>)src)).whenComplete((nil, err) -> {
            if (err != null) {
                this.handleNetworkError((Throwable)err);
                try {
                    Thread.sleep(this.discoverRetryMs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.loopIfLatest(request);
        });
    }

    synchronized void loopIfLatest(CompletionStage<Set<Source>> request) {
        if (request == this.lastRequest) {
            this.doRequest();
        }
    }

    public synchronized List<Source> getSources() {
        return new ArrayList<Source>(this.currentSources);
    }

    <T> T handleNetworkError(Throwable error) {
        this.emitError(error);
        return null;
    }

    SessionToken monitorAuthentication(SessionToken token) {
        if (this.isLoggedIn.get()) {
            if (token == null || !token.isAuthenticated()) {
                if (token != null && !token.getError().isEmpty()) {
                    this.emitError(new AuthenticationException(token.getError()));
                }
                this.emitDisconnect(this.discoveryClient.getUsername());
                this.isLoggedIn.set(false);
            }
        } else if (token != null) {
            if (token.isAuthenticated()) {
                this.emitConnection(this.discoveryClient.getUsername());
                this.isLoggedIn.set(true);
            } else if (!token.getError().isEmpty()) {
                this.emitError(new AuthenticationException(token.getError()));
            }
        }
        return token;
    }

    CompletionStage<Set<Source>> doQuery(SessionToken token) {
        JsonNode query;
        try {
            query = this.makeJsonRequest(this.discoveryClient.getAdvertisements(), this.exclusions);
        }
        catch (IOException e) {
            this.emitError(e);
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage<StandaloneWSResponse> response = Utils.post(this.discoveryClient.makeUserRequest("/discover", token).setRequestTimeout(HTTP_TIMEOUT), query);
        return response.thenCompose(this::parseStreamSource).thenApply(Discoverer::toOutputList);
    }

    CompletableFuture<List<SourceJson>> parseStreamSource(StandaloneWSResponse httpResponse) {
        int status = httpResponse.getStatus();
        CompletableFuture<List<SourceJson>> exception = new CompletableFuture<List<SourceJson>>();
        switch (status) {
            case 200: {
                try {
                    JsonNode jsonResponse = this.discoveryClient.getJsonMapper().readTree(httpResponse.getBody());
                    List<SourceJson> streams = this.parseJsonStreamSources(jsonResponse.path("streamConnections"));
                    return CompletableFuture.completedFuture(streams);
                }
                catch (IOException e) {
                    exception.completeExceptionally(e);
                    return exception;
                }
            }
            case 401: {
                this.discoveryClient.forceLogout();
                exception.completeExceptionally(new IOException("Session token expired"));
                return exception;
            }
        }
        exception.completeExceptionally(new IOException("Unknown error: (" + status + ")"));
        return exception;
    }

    static Set<Source> toOutputList(List<SourceJson> source) {
        return source.stream().map(Source::new).collect(Collectors.toSet());
    }

    List<SourceJson> parseJsonStreamSources(JsonNode json) throws IOException {
        if (json.isMissingNode()) {
            throw new IOException("Unexpected server response");
        }
        ObjectMapper mapper = this.discoveryClient.getJsonMapper();
        String jsonText = json.toString();
        return Arrays.asList((Object[])mapper.readValue(jsonText, SourceJson[].class));
    }

    JsonNode makeJsonRequest(List<StreamJson> streams, List<String> exclusion) throws IOException {
        ObjectNode query = this.discoveryClient.getJsonMapper().createObjectNode();
        query.set("streams", this.toJson(streams));
        query.set("state", this.toJson(this.getCurrentSources()));
        if (this.scope != null) {
            query.set("scope", this.toJson(this.scope));
        }
        if (exclusion != null && !exclusion.isEmpty()) {
            query.set("excludes", this.toJson(exclusion));
        }
        if (!this.allowedProtocols.isEmpty()) {
            query.set("protocols", this.toJson(this.allowedProtocols));
        }
        return query;
    }

    public Discoverer discover(byte group, String stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream names cannot be null");
        }
        if (!Discoverer.isValidRegex(stream)) {
            throw new IllegalArgumentException("Stream names are not valid regexes");
        }
        this.discoveryClient.advertise(Utils.serializeByte(group), stream);
        this.update();
        return this;
    }

    public synchronized Discoverer with(String scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException("Scheme cannot be null");
        }
        if (scheme.isEmpty()) {
            throw new IllegalArgumentException("Schemes cannot be empty");
        }
        this.allowedProtocols.add(scheme);
        this.update();
        return this;
    }

    public void remove(byte group) {
        this.discoveryClient.remove(Utils.serializeByte(group));
        this.update();
    }

    public void remove(byte group, String stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream names cannot be null");
        }
        if (!Discoverer.isValidRegex(stream)) {
            throw new IllegalArgumentException("Stream name is not a valid regex");
        }
        this.discoveryClient.remove(Utils.serializeByte(group), stream);
        this.update();
    }

    public synchronized void excluding(String source) {
        if (source == null) {
            throw new IllegalArgumentException("Datafront connections cannot be null");
        }
        this.exclusions.add(source);
        this.update();
    }

    public synchronized void removeExclusion(String source) {
        if (source == null) {
            throw new IllegalArgumentException("Datafront connections cannot be null");
        }
        this.exclusions.remove(source);
        this.update();
    }

    public synchronized void clear() {
        this.allowedProtocols.clear();
        this.discoveryClient.clear();
        this.exclusions.clear();
        this.update();
    }

    void emitError(Throwable error) {
        for (Consumer<Throwable> listener : this.errorListeners) {
            listener.accept(error);
        }
    }

    void emitConnection(String msg) {
        for (Consumer<String> listener : this.connectListeners) {
            listener.accept(msg);
        }
    }

    void emitDisconnect(String msg) {
        for (Consumer<String> listener : this.disconnectListeners) {
            listener.accept(msg);
        }
    }

    void emitUpdate(Set<Source> sources) {
        for (Consumer<List<Source>> listener : this.updateListeners) {
            listener.accept(new ArrayList<Source>(sources));
        }
    }

    static boolean isValidRegex(String regex) {
        try {
            Pattern.compile(regex);
            return true;
        }
        catch (PatternSyntaxException err) {
            return false;
        }
    }

    synchronized void setSourceIfLatest(CompletionStage<Set<Source>> request, Set<Source> sources) {
        if (request == this.lastRequest) {
            this.setCurrentSources(sources);
        }
    }

    synchronized void setCurrentSources(Set<Source> sources) {
        if (sources != null && !sources.equals(this.currentSources)) {
            this.emitUpdate(sources);
        }
        this.currentSources = sources;
    }

    synchronized List<SourceJson> getCurrentSources() {
        return this.currentSources.stream().map(Source::asSourceJson).collect(Collectors.toList());
    }

    JsonNode toJson(Object value) throws IOException {
        return this.discoveryClient.getJsonMapper().valueToTree(value);
    }

    static StreamfinderConfig config(String filename) {
        return (StreamfinderConfig)JacksonConfig.readConfig((String)filename, null, StreamfinderConfig.class, (JacksonConfigFormat)JacksonConfigFormat.JSON);
    }
}

