/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder;

import java.net.URI;
import jayeson.lib.streamfinder.internal.SourceJson;
import jayeson.lib.streamfinder.internal.Utils;

public final class Source {
    final SourceJson json;

    public Source(byte group, String stream, int level, String serviceId, URI connection) {
        this.json = new SourceJson(Utils.serializeByte(group), stream, level, serviceId, connection);
    }

    public Source(SourceJson json) {
        this.json = json;
    }

    public byte getGroup() {
        return Utils.deserializeByte(this.json.getGroupName());
    }

    public String getStreamName() {
        return this.json.getStreamName();
    }

    public URI getConnection() {
        return this.json.getConnection();
    }

    public int getLevel() {
        return this.json.getLevel();
    }

    public String getServiceId() {
        return this.json.getServiceId();
    }

    public SourceJson asSourceJson() {
        return this.json;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getGroup();
        result = 31 * result + (this.getStreamName() == null ? 0 : this.getStreamName().hashCode());
        result = 31 * result + this.getLevel();
        result = 31 * result + (this.getConnection() == null ? 0 : this.getConnection().hashCode());
        result = 31 * result + (this.getServiceId() == null ? 0 : this.getServiceId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Source other = (Source)obj;
        if (this.getGroup() != other.getGroup()) {
            return false;
        }
        if (this.getStreamName() == null ? other.getStreamName() != null : !this.getStreamName().equals(other.getStreamName())) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getConnection() == null ? other.getConnection() != null : !this.getConnection().equals(other.getConnection())) {
            return false;
        }
        return !(this.getServiceId() == null ? other.getServiceId() != null : !this.getServiceId().equals(other.getServiceId()));
    }

    public String toString() {
        return "Source [getGroup()=" + this.getGroup() + ", getStreamName()=" + this.getStreamName() + ", getConnection()=" + this.getConnection() + ", getLevel()=" + this.getLevel() + "]";
    }
}

