/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import jayeson.lib.streamfinder.AdvertiserFactory;
import jayeson.lib.streamfinder.DiscovererFactory;
import jayeson.lib.streamfinder.SessionFactory;
import jayeson.lib.streamfinder.internal.AdvertiserFactoryImpl;
import jayeson.lib.streamfinder.internal.DiscoveryClientFactory;
import jayeson.lib.streamfinder.internal.UriDeserializer;
import jayeson.lib.streamfinder.internal.UriSerializer;
import jayeson.utility.UtilityModule;
import play.libs.ws.StandaloneWSClient;
import play.libs.ws.ahc.StandaloneAhcWSClient;
import play.shaded.ahc.org.asynchttpclient.AsyncHttpClient;
import play.shaded.ahc.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import play.shaded.ahc.org.asynchttpclient.Dsl;

public class StreamfinderModule
extends AbstractModule {
    public static final String SF_HTTP_CLIENT = "SF_HTTP_CLIENT";
    public static final String SF_MAPPER = "SF_MAPPER";

    protected void configure() {
        ObjectMapper jsonMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(URI.class, (JsonSerializer)new UriSerializer());
        module.addDeserializer(URI.class, (JsonDeserializer)new UriDeserializer());
        jsonMapper.registerModule((com.fasterxml.jackson.databind.Module)module);
        this.bind(ObjectMapper.class).annotatedWith((Annotation)Names.named((String)SF_MAPPER)).toInstance((Object)jsonMapper);
        this.bind(StandaloneWSClient.class).annotatedWith((Annotation)Names.named((String)SF_HTTP_CLIENT)).toInstance((Object)this.makeHttpClient());
        this.bind(SessionFactory.class);
        this.install((Module)new UtilityModule());
        this.install(new FactoryModuleBuilder().build(DiscoveryClientFactory.class));
        this.bind(AdvertiserFactory.class).to(AdvertiserFactoryImpl.class);
        this.install(new FactoryModuleBuilder().build(DiscovererFactory.class));
    }

    protected StandaloneWSClient makeHttpClient() {
        DefaultAsyncHttpClientConfig.Builder clientConfig = Dsl.config().setConnectTimeout(120000).setPooledConnectionIdleTimeout(120000).setRequestTimeout(120000).setFollowRedirect(true).setUseProxyProperties(false).setUserAgent("").setCookieStore(null).setCompressionEnforced(true);
        AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)clientConfig);
        return new StandaloneAhcWSClient(client, null);
    }
}

