/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jayeson.database.FeedUser;
import jayeson.database.delivery.FeedRole;
import jayeson.database.delivery.FeedStreamPermission;
import jayeson.lib.streamfinder.internal.Utils;
import org.apache.commons.lang3.text.StrSubstitutor;

public class User {
    final FeedUser user;

    public User(FeedUser user) {
        this.user = user;
    }

    public void fetchPermissions() {
        FeedRole role = this.user.getRole();
        if (role == null) {
            throw new UnsupportedOperationException(this.user.getUsername() + " is not a feed user");
        }
        role.getPermissions().size();
        this.subVariables();
    }

    void subVariables() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("username", this.getUsername());
        StrSubstitutor subber = new StrSubstitutor(values, "%", "%");
        this.user.getRole().getPermissions().stream().forEach(permission -> {
            String resolvedStream = subber.replace(permission.getStream());
            permission.setStream(resolvedStream);
        });
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public boolean canAccess(byte group, String stream) {
        String groupName = Utils.serializeByte(group);
        return this.canAccess(groupName, stream);
    }

    public boolean canAccess(String group, String stream) {
        Stream<FeedStreamPermission> currentGroupPermissions = this.groupPermissionsFor(group);
        List streams = currentGroupPermissions.map(FeedStreamPermission::getStream).collect(Collectors.toList());
        String groupStreamPatterns = "^(" + String.join((CharSequence)"|", streams) + ")$";
        return Pattern.matches(groupStreamPatterns, stream);
    }

    public int levelAccessTo(byte group, String stream) {
        String groupName = Utils.serializeByte(group);
        return this.levelAccessTo(groupName, stream);
    }

    public int levelAccessTo(String group, String stream) {
        FeedStreamPermission p = this.bestPermissionFor(group, stream);
        return p.getBestLevel();
    }

    public long getConfigIdFor(byte group, String stream) {
        String groupName = Utils.serializeByte(group);
        return this.getConfigIdFor(groupName, stream);
    }

    public long getConfigIdFor(String group, String stream) {
        FeedStreamPermission p = this.bestPermissionFor(group, stream);
        return p.getConfig_id();
    }

    FeedStreamPermission bestPermissionFor(String group, String stream) {
        Stream<FeedStreamPermission> currentGroupPermissions = this.groupPermissionsFor(group);
        Optional<FeedStreamPermission> bestPermission = currentGroupPermissions.filter(permission -> Pattern.matches(permission.getStream(), stream)).sorted((p1, p2) -> Integer.compare(p1.getPriority(), p2.getPriority())).findFirst();
        return bestPermission.orElseThrow(() -> new IllegalStateException());
    }

    Stream<FeedStreamPermission> groupPermissionsFor(String group) {
        Stream permissions = this.user.getRole().getPermissions().stream();
        Stream<FeedStreamPermission> currentGroupPermissions = permissions.filter(access -> access.getGroup().equalsIgnoreCase(group));
        return currentGroupPermissions;
    }
}

