/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import jayeson.database.DatabaseManager;
import jayeson.database.FeedUser;
import jayeson.lib.streamfinder.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UserRepository {
    static final long MAX_CACHE_AGE_S = 60L;
    Cache<String, User> userCache;
    DatabaseManager manager;
    static final Logger log = LoggerFactory.getLogger(UserRepository.class);

    @Inject
    public UserRepository(DatabaseManager manager) {
        this.manager = manager;
        this.userCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    }

    public User findFeedUserByName(String persistUnit, String name) {
        try {
            return (User)this.userCache.get((Object)name, () -> this.queryUserBy(name, true, persistUnit));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            log.error("Error while querying user " + e.getMessage() + " | " + Arrays.asList(e.getStackTrace()));
            return null;
        }
    }

    public User findFeedUserByName(String name) {
        return this.findFeedUserByName(null, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    User queryUserBy(String name, boolean fetchPremissions, String persistUnit) {
        try (EntityManager em = persistUnit == null || persistUnit.isEmpty() ? this.manager.getEM() : this.manager.getEM(persistUnit);){
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            User user = new User(FeedUser.findByUserName((EntityManager)em, (String)name));
            tx.commit();
            if (fetchPremissions) {
                user.fetchPermissions();
            }
            User user2 = user;
            return user2;
        }
    }
}

