/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jayeson.lib.streamfinder.internal.AdvertDelta;
import jayeson.lib.streamfinder.internal.AdvertMessageTools;
import jayeson.lib.streamfinder.internal.AdvertSnapshot;
import jayeson.lib.streamfinder.internal.DiscoveryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.StandaloneWSResponse;

public class AdvertChannel
implements Runnable {
    AdvertSnapshot currAdvert;
    AdvertSnapshot prevAdvert;
    boolean isConnected;
    boolean hasError;
    final BlockingQueue<Boolean> latch;
    final AdvertMessageTools util;
    DiscoveryClient discoveryClient;
    long advertRateS;
    final Object lock;
    static final Logger log = LoggerFactory.getLogger(AdvertChannel.class);

    @Inject
    public AdvertChannel(AdvertMessageTools differ) {
        this.util = differ;
        this.latch = new ArrayBlockingQueue<Boolean>(1);
        this.isConnected = false;
        this.hasError = false;
        this.lock = new Object();
    }

    public void start() {
        ExecutorService ctx = Executors.newSingleThreadExecutor();
        ctx.execute(this);
    }

    public void setDiscoveryClient(DiscoveryClient discoveryClient) {
        this.discoveryClient = discoveryClient;
    }

    public DiscoveryClient getDiscoveryClient() {
        return this.discoveryClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentAdvert(AdvertSnapshot request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        Object object = this.lock;
        synchronized (object) {
            this.currAdvert = request;
        }
        this.latch.offer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdvertSnapshot getCurrentAdvert() {
        Object object = this.lock;
        synchronized (object) {
            return this.currAdvert;
        }
    }

    public long getAdvertRateS() {
        return this.advertRateS;
    }

    public void setAdvertRateS(long advertRateS) {
        this.advertRateS = advertRateS;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.blockingWait();
                    CompletionStage<Boolean> blockingRequest = this.doRequest();
                    blockingRequest.toCompletableFuture().get();
                }
            }
            catch (Throwable e) {
                log.error("Unknown error in sender", e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockingWait() throws InterruptedException {
        if (this.hasError) {
            Thread.sleep(10000L);
        } else if (this.isConnected) {
            this.latch.poll(this.advertRateS, TimeUnit.SECONDS);
        } else {
            AdvertChannel advertChannel = this;
            synchronized (advertChannel) {
                this.wait();
            }
        }
    }

    public CompletionStage<Boolean> doRequest() {
        if (this.isReady()) {
            return this.sendHttpRequest().handle(this::parseAdvertResponse);
        }
        return CompletableFuture.completedFuture(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletionStage<StandaloneWSResponse> sendHttpRequest() {
        try {
            AdvertSnapshot previous;
            AdvertSnapshot current;
            Object object = this.lock;
            synchronized (object) {
                current = this.getCurrentAdvert();
                previous = this.prevAdvert;
                this.prevAdvert = current;
            }
            AdvertDelta delta = this.util.diffSnapshots(previous, current);
            List<AdvertDelta> deltaChunks = this.util.splitDelta(delta);
            List chunks = deltaChunks.stream().map(this.util::toJson).collect(Collectors.toList());
            CompletionStage<Object> request = CompletableFuture.completedFuture(null);
            for (JsonNode chunk : chunks) {
                request = request.thenCompose(r -> {
                    log.trace("Sending advert chunk: " + chunk);
                    return this.discoveryClient.makeProtectedRequest("/advertise", chunk);
                });
            }
            return request;
        }
        catch (Throwable e) {
            CompletableFuture<StandaloneWSResponse> errorRes = new CompletableFuture<StandaloneWSResponse>();
            errorRes.completeExceptionally(e);
            return errorRes;
        }
    }

    boolean isReady() {
        return this.getCurrentAdvert() != null;
    }

    boolean parseAdvertResponse(StandaloneWSResponse httpResponse, Throwable error) {
        if (error != null) {
            log.warn("Unable to complete advertisement request ", error);
            this.prevAdvert = null;
        }
        this.hasError = error == null;
        return this.hasError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean value) {
        this.isConnected = value;
        if (this.isConnected) {
            AdvertChannel advertChannel = this;
            synchronized (advertChannel) {
                this.notifyAll();
            }
        }
    }
}

