/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionStage;
import jayeson.lib.streamfinder.AuthenticationException;
import jayeson.lib.streamfinder.SessionFactory;
import jayeson.lib.streamfinder.SessionToken;
import jayeson.lib.streamfinder.internal.Advertisement;
import jayeson.lib.streamfinder.internal.StreamJson;
import jayeson.lib.streamfinder.internal.UriDeserializer;
import jayeson.lib.streamfinder.internal.UriSerializer;
import jayeson.lib.streamfinder.internal.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.StandaloneWSClient;
import play.libs.ws.StandaloneWSRequest;
import play.libs.ws.StandaloneWSResponse;

public class DiscoveryClient {
    Advertisement adverts;
    final String username;
    final String password;
    final String discoveryUrl;
    final StandaloneWSClient httpClient;
    final ObjectMapper jsonMapper;
    final SessionFactory sessionFactory;
    static final Duration HTTP_TIMEOUT_MS = Duration.ofMillis(5000L);
    static final Logger log = LoggerFactory.getLogger(DiscoveryClient.class);

    @Inject
    public DiscoveryClient(@Assisted(value="username") String username, @Assisted(value="password") String password, @Assisted(value="url") String discoveryUrl, @Named(value="SF_HTTP_CLIENT") StandaloneWSClient httpClient, SessionFactory sessionFactory) {
        if (username == null) {
            throw new IllegalArgumentException("Username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        if (discoveryUrl == null || discoveryUrl.isEmpty()) {
            throw new IllegalArgumentException("Streamfinder server URL is not valid");
        }
        Utils.parseUri(discoveryUrl);
        if (httpClient == null) {
            throw new IllegalArgumentException("Http client cannot be null");
        }
        this.username = username;
        this.password = password;
        this.discoveryUrl = discoveryUrl;
        this.adverts = new Advertisement();
        this.httpClient = httpClient;
        this.sessionFactory = sessionFactory;
        this.jsonMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(URI.class, (JsonSerializer)new UriSerializer());
        module.addDeserializer(URI.class, (JsonDeserializer)new UriDeserializer());
        this.jsonMapper.registerModule((Module)module);
    }

    public CompletionStage<SessionToken> doLogin() {
        return this.sessionFactory.getSession(this.username, this.password, this.discoveryUrl);
    }

    public void forceLogout() {
        this.sessionFactory.invalidate(this.username, this.password, this.discoveryUrl);
    }

    public StandaloneWSRequest makeUserRequest(String method, SessionToken token) {
        return this.httpClient.url(this.discoveryUrl + method).setRequestTimeout(HTTP_TIMEOUT_MS).addHeader("Cookie", token.getCookie());
    }

    public <T> CompletionStage<StandaloneWSResponse> makeProtectedRequest(String method, T data) {
        CompletionStage<SessionToken> loginRequest = this.doLogin().thenApply(this::throwAuthFailAsError);
        CompletionStage<StandaloneWSResponse> protectedRequest = loginRequest.thenCompose(token -> Utils.post(this.makeUserRequest(method, (SessionToken)token), data));
        CompletionStage<StandaloneWSResponse> request = protectedRequest.thenApply(this::throwRequestFailAsError);
        return request.whenComplete(this::logoutIfFailure);
    }

    void logoutIfFailure(StandaloneWSResponse res, Throwable error) {
        if (error != null) {
            this.forceLogout();
        }
    }

    StandaloneWSResponse throwRequestFailAsError(StandaloneWSResponse req) {
        int status = req.getStatus();
        String body = req.getBody();
        if (status != 200) {
            throw new AuthenticationException("Failed to complete request (" + status + "): " + body);
        }
        return req;
    }

    SessionToken throwAuthFailAsError(SessionToken token) {
        if (!token.isAuthenticated()) {
            throw new AuthenticationException("Unable to login: " + token.getError());
        }
        return token;
    }

    public synchronized void advertise(String group, String stream) {
        this.adverts = this.adverts.advertise(group, stream);
    }

    public synchronized void advertise(String group, String stream, int level) {
        this.adverts = this.adverts.advertise(group, stream, level);
    }

    public synchronized void remove(String group) {
        this.adverts = this.adverts.remove(group);
    }

    public synchronized void remove(String group, String stream) {
        this.adverts = this.adverts.remove(group, stream);
    }

    public synchronized void clear() {
        this.adverts = this.adverts.clear();
    }

    public synchronized List<StreamJson> getAdvertisements() {
        return this.adverts.getAdvertisements();
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public String getUsername() {
        return this.username;
    }

    public Advertisement getAdverts() {
        return this.adverts;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }
}

