/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.streamfinder.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.BodyWritable;
import play.libs.ws.DefaultBodyWritables;
import play.libs.ws.JsonBodyWritables;
import play.libs.ws.StandaloneWSRequest;
import play.libs.ws.StandaloneWSResponse;

@Singleton
public class Utils
implements DefaultBodyWritables,
JsonBodyWritables {
    final ScheduledExecutorService executor;
    static final Logger log = LoggerFactory.getLogger(Utils.class);
    static final DefaultBodyWritables bodyWritables = new DefaultBodyWritables(){};
    static final JsonBodyWritables jsonWritables = new JsonBodyWritables(){};

    @Inject
    public Utils(@Named(value="CommonSES") ScheduledExecutorService ses) {
        this.executor = ses;
    }

    public CompletionStage<Void> waitFor(Duration duration) {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.executor.schedule(() -> promise.complete(null), duration.toMillis(), TimeUnit.MILLISECONDS);
        return promise;
    }

    public static <T> CompletionStage<StandaloneWSResponse> post(StandaloneWSRequest request, T param) {
        CompletionStage response = null;
        BodyWritable input = null;
        if (param instanceof JsonNode) {
            input = jsonWritables.body((JsonNode)param);
        } else if (param instanceof Map) {
            input = bodyWritables.body((Map)param);
        } else if (param instanceof String) {
            input = bodyWritables.body((String)param);
        } else {
            throw new UnsupportedOperationException("Post request not supported for type: " + param.getClass().getName());
        }
        response = request.post(input);
        return response;
    }

    public static URI parseUri(String url) {
        URI location;
        if (url.isEmpty()) {
            throw new IllegalArgumentException("URL cannot be empty");
        }
        try {
            location = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse URL", e);
        }
        if (location.getScheme() == null) {
            throw new IllegalArgumentException("Missing or invalid protocol");
        }
        if (location.getHost() == null) {
            throw new IllegalArgumentException("Missing or invalid hostname");
        }
        return location;
    }

    public static String serializeByte(byte num) {
        int asUByte = Byte.toUnsignedInt(num);
        return Integer.toString(asUByte);
    }

    public static byte deserializeByte(String text) {
        int asUByte = Integer.parseInt(text);
        return (byte)(asUByte & 0xFF);
    }
}

