/*
 * Decompiled with CFR 0.152.
 */
package imageserviceclient;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AntigateDecoder {
    private static final Logger log = LoggerFactory.getLogger(AntigateDecoder.class);
    DefaultHttpClient httpclient = new DefaultHttpClient();

    public String getCaptchaID(File file, String key) {
        HttpPost postMsg = new HttpPost("http://antigate.com/in.php");
        MultipartEntity entity = new MultipartEntity();
        FileBody img_body = new FileBody(file);
        StringBody key_body = null;
        StringBody method = null;
        String post_content = null;
        try {
            key_body = new StringBody(key);
            method = new StringBody("post");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Unsupported Encoding exception:", (Throwable)e);
        }
        entity.addPart("method", (ContentBody)method);
        entity.addPart("key", (ContentBody)key_body);
        entity.addPart("file", (ContentBody)img_body);
        postMsg.setEntity((HttpEntity)entity);
        HttpResponse response = null;
        try {
            response = this.httpclient.execute((HttpUriRequest)postMsg);
        }
        catch (IOException e) {
            log.error("Failed to execute Message:", (Throwable)e);
        }
        InputStream istream = null;
        try {
            istream = response.getEntity().getContent();
        }
        catch (IOException e) {
            log.error("Failed to read response message:", (Throwable)e);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(istream));
        try {
            post_content = br.readLine();
        }
        catch (IOException e) {
            log.error("Exception occured while reading input stream:", (Throwable)e);
        }
        return post_content;
    }

    public String getCaptchaText(String key, String captcha_id) {
        String captcha_text = null;
        HttpGet getMsg = new HttpGet("http://antigate.com/res.php?key=" + key + "&action=get&id=" + captcha_id);
        HttpResponse response = null;
        InputStream istream = null;
        try {
            response = this.httpclient.execute((HttpUriRequest)getMsg);
        }
        catch (ClientProtocolException e) {
            log.error("Client Protocol Exception:", (Throwable)e);
        }
        catch (IOException e) {
            log.error("IO Exception:", (Throwable)e);
        }
        try {
            istream = response.getEntity().getContent();
        }
        catch (IOException e) {
            log.error("IO Exception when reading response:", (Throwable)e);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(istream));
        try {
            captcha_text = br.readLine();
        }
        catch (IOException e) {
            log.error("Exception raised while reading buffer:", (Throwable)e);
        }
        return captcha_text;
    }

    public String getCaptcha(File file, String key) {
        return this.getCaptcha(file, key, 0);
    }

    public String getCaptcha(File file, String key, int noSlotNumRetry) {
        String captcha_id = this.getCaptchaID(file, key);
        for (int retryCount = 0; captcha_id.contains("ERROR_NO_SLOT_AVAILABLE") && (noSlotNumRetry == 0 || retryCount < noSlotNumRetry); ++retryCount) {
            try {
                log.info("NO SLOT Avaliable, Waiting to request again");
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error("Thread interrupted::", (Throwable)e);
            }
            captcha_id = this.getCaptchaID(file, key);
        }
        if (captcha_id.contains("ERROR_NO_SLOT_AVAILABLE")) {
            return captcha_id;
        }
        if (captcha_id.contains("OK")) {
            captcha_id = captcha_id.replace("OK|", "");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                log.error("Thread Interrupted:", (Throwable)e);
            }
            String captcha_status = this.getCaptchaText(key, captcha_id);
            while (!captcha_status.contains("OK")) {
                captcha_status = this.getCaptchaText(key, captcha_id);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    log.error("Thread Interrupted:", (Throwable)e);
                }
            }
            captcha_status = captcha_status.replace("OK|", "");
            return captcha_status;
        }
        log.info("Captcha decode Unsuccessful because:" + captcha_id);
        return captcha_id;
    }
}

