/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.fusing;

import akka.annotation.InternalApi;
import akka.stream.Attributes;
import akka.stream.FlowShape;
import akka.stream.Inlet;
import akka.stream.Inlet$;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.impl.Stages$DefaultAttributes$;
import akka.stream.impl.fusing.GroupedWeightedWithin$;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import akka.stream.stage.InHandler;
import akka.stream.stage.OutHandler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.VectorBuilder;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015rA\u0002\u000b\u0016\u0011\u0003YRD\u0002\u0004 +!\u00051\u0004\t\u0005\u0006O\u0005!\t!\u000b\u0005\bU\u0005\u0011\r\u0011\"\u0001,\u0011\u0019!\u0014\u0001)A\u0005Y\u0019)q$\u0006\u0002\u001c{!AA,\u0002BC\u0002\u0013\u0005Q\f\u0003\u0005b\u000b\t\u0005\t\u0015!\u0003_\u0011!\u0011WA!A!\u0002\u0013\u0019\u0007\u0002\u00034\u0006\u0005\u000b\u0007I\u0011A4\t\u0011A,!\u0011!Q\u0001\n!DQaJ\u0003\u0005\u0002EDqA^\u0003C\u0002\u0013\u0005q\u000f\u0003\u0004|\u000b\u0001\u0006I\u0001\u001f\u0005\by\u0016\u0011\r\u0011\"\u0001~\u0011\u001d\t\u0019!\u0002Q\u0001\nyDq!!\u0002\u0006\t\u0003\n9\u0001C\u0005\u0002\u0010\u0015\u0011\r\u0011\"\u0001\u0002\u0012!9\u00111C\u0003!\u0002\u0013)\u0005bBA\u000b\u000b\u0011\u0005\u0013qC\u0001\u0016\u000fJ|W\u000f]3e/\u0016Lw\r\u001b;fI^KG\u000f[5o\u0015\t1r#\u0001\u0004gkNLgn\u001a\u0006\u00031e\tA![7qY*\u0011!dG\u0001\u0007gR\u0014X-Y7\u000b\u0003q\tA!Y6lCB\u0011a$A\u0007\u0002+\t)rI]8va\u0016$w+Z5hQR,GmV5uQ&t7CA\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001e\u0003i9'o\\;qK\u0012<V-[4ii\u0016$w+\u001b;iS:$\u0016.\\3s+\u0005a\u0003CA\u00173\u001b\u0005q#BA\u00181\u0003\u0011a\u0017M\\4\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0007'R\u0014\u0018N\\4\u00027\u001d\u0014x.\u001e9fI^+\u0017n\u001a5uK\u0012<\u0016\u000e\u001e5j]RKW.\u001a:!Q\t\ta\u0007\u0005\u00028u5\t\u0001H\u0003\u0002:7\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005mB$aC%oi\u0016\u0014h.\u00197Ba&D#\u0001\u0001\u001c\u0016\u0005yZ5CA\u0003@!\r\u00015)R\u0007\u0002\u0003*\u0011!)G\u0001\u0006gR\fw-Z\u0005\u0003\t\u0006\u0013!b\u0012:ba\"\u001cF/Y4f!\u00111u)\u0013+\u000e\u0003eI!\u0001S\r\u0003\u0013\u0019cwn^*iCB,\u0007C\u0001&L\u0019\u0001!Q\u0001T\u0003C\u00025\u0013\u0011\u0001V\t\u0003\u001dF\u0003\"AI(\n\u0005A\u001b#a\u0002(pi\"Lgn\u001a\t\u0003EIK!aU\u0012\u0003\u0007\u0005s\u0017\u0010E\u0002V5&k\u0011A\u0016\u0006\u0003/b\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005e\u001b\u0013AC2pY2,7\r^5p]&\u00111L\u0016\u0002\u0004'\u0016\f\u0018!C7bq^+\u0017n\u001a5u+\u0005q\u0006C\u0001\u0012`\u0013\t\u00017E\u0001\u0003M_:<\u0017AC7bq^+\u0017n\u001a5uA\u000511m\\:u\r:\u0004BA\t3J=&\u0011Qm\t\u0002\n\rVt7\r^5p]F\n\u0001\"\u001b8uKJ4\u0018\r\\\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\tIV\u0014\u0018\r^5p]*\u0011QnI\u0001\u000bG>t7-\u001e:sK:$\u0018BA8k\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\f\u0011\"\u001b8uKJ4\u0018\r\u001c\u0011\u0015\tI\u001cH/\u001e\t\u0004=\u0015I\u0005\"\u0002/\f\u0001\u0004q\u0006\"\u00022\f\u0001\u0004\u0019\u0007\"\u00024\f\u0001\u0004A\u0017AA5o+\u0005A\bc\u0001$z\u0013&\u0011!0\u0007\u0002\u0006\u0013:dW\r^\u0001\u0004S:\u0004\u0013aA8viV\ta\u0010E\u0002G\u007fRK1!!\u0001\u001a\u0005\u0019yU\u000f\u001e7fi\u0006!q.\u001e;!\u0003EIg.\u001b;jC2\fE\u000f\u001e:jEV$Xm]\u000b\u0003\u0003\u0013\u00012ARA\u0006\u0013\r\ti!\u0007\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c\u0018!B:iCB,W#A#\u0002\rMD\u0017\r]3!\u0003-\u0019'/Z1uK2{w-[2\u0015\t\u0005e\u0011q\u0004\t\u0004\u0001\u0006m\u0011bAA\u000f\u0003\nyqI]1qQN#\u0018mZ3M_\u001eL7\rC\u0004\u0002\"M\u0001\r!!\u0003\u0002'%t\u0007.\u001a:ji\u0016$\u0017\t\u001e;sS\n,H/Z:)\u0005\u00151\u0004")
@InternalApi
public final class GroupedWeightedWithin<T>
extends GraphStage<FlowShape<T, scala.collection.immutable.Seq<T>>> {
    private final long maxWeight;
    public final Function1<T, Object> akka$stream$impl$fusing$GroupedWeightedWithin$$costFn;
    private final FiniteDuration interval;
    private final Inlet<T> in;
    private final Outlet<scala.collection.immutable.Seq<T>> out;
    private final FlowShape<T, scala.collection.immutable.Seq<T>> shape;

    public static String groupedWeightedWithinTimer() {
        return GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer();
    }

    public long maxWeight() {
        return this.maxWeight;
    }

    public FiniteDuration interval() {
        return this.interval;
    }

    public Inlet<T> in() {
        return this.in;
    }

    public Outlet<scala.collection.immutable.Seq<T>> out() {
        return this.out;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.groupedWeightedWithin();
    }

    @Override
    public FlowShape<T, scala.collection.immutable.Seq<T>> shape() {
        return this.shape;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private final VectorBuilder<T> buf;
            private T pending;
            private long pendingWeight;
            private boolean pushEagerly;
            private boolean groupEmitted;
            private boolean finished;
            private long totalWeight;
            private boolean hasElements;
            private final /* synthetic */ GroupedWeightedWithin $outer;

            public void onDownstreamFinish() throws Exception {
                OutHandler.onDownstreamFinish$(this);
            }

            public void onDownstreamFinish(Throwable cause) throws Exception {
                OutHandler.onDownstreamFinish$(this, cause);
            }

            public void onUpstreamFailure(Throwable ex) throws Exception {
                InHandler.onUpstreamFailure$(this, ex);
            }

            private VectorBuilder<T> buf() {
                return this.buf;
            }

            private T pending() {
                return this.pending;
            }

            private void pending_$eq(T x$1) {
                this.pending = x$1;
            }

            private long pendingWeight() {
                return this.pendingWeight;
            }

            private void pendingWeight_$eq(long x$1) {
                this.pendingWeight = x$1;
            }

            private boolean pushEagerly() {
                return this.pushEagerly;
            }

            private void pushEagerly_$eq(boolean x$1) {
                this.pushEagerly = x$1;
            }

            private boolean groupEmitted() {
                return this.groupEmitted;
            }

            private void groupEmitted_$eq(boolean x$1) {
                this.groupEmitted = x$1;
            }

            private boolean finished() {
                return this.finished;
            }

            private void finished_$eq(boolean x$1) {
                this.finished = x$1;
            }

            private long totalWeight() {
                return this.totalWeight;
            }

            private void totalWeight_$eq(long x$1) {
                this.totalWeight = x$1;
            }

            private boolean hasElements() {
                return this.hasElements;
            }

            private void hasElements_$eq(boolean x$1) {
                this.hasElements = x$1;
            }

            public void preStart() {
                this.scheduleWithFixedDelay((Object)GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval(), this.$outer.interval());
                this.pull(this.$outer.in());
            }

            private void nextElement(T elem) {
                this.groupEmitted_$eq(false);
                long cost = BoxesRunTime.unboxToLong((Object)this.$outer.akka$stream$impl$fusing$GroupedWeightedWithin$$costFn.apply(elem));
                if (cost < 0L) {
                    this.failStage(new IllegalArgumentException(new StringBuilder(48).append("Negative weight [").append(cost).append("] for element [").append(elem).append("] is not allowed").toString()));
                } else {
                    this.hasElements_$eq(true);
                    if (this.totalWeight() + cost <= this.$outer.maxWeight()) {
                        this.buf().$plus$eq(elem);
                        this.totalWeight_$eq(this.totalWeight() + cost);
                        if (this.totalWeight() < this.$outer.maxWeight()) {
                            this.pull(this.$outer.in());
                        } else if (!this.isAvailable(this.$outer.out())) {
                            this.pushEagerly_$eq(true);
                            this.pull(this.$outer.in());
                        } else {
                            this.scheduleWithFixedDelay((Object)GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval(), this.$outer.interval());
                            this.emitGroup();
                        }
                    } else {
                        if (this.totalWeight() == 0L) {
                            this.buf().$plus$eq(elem);
                            this.totalWeight_$eq(this.totalWeight() + cost);
                            this.pushEagerly_$eq(true);
                        } else {
                            this.pending_$eq(elem);
                            this.pendingWeight_$eq(cost);
                        }
                        this.scheduleWithFixedDelay((Object)GroupedWeightedWithin$.MODULE$.groupedWeightedWithinTimer(), this.$outer.interval(), this.$outer.interval());
                        this.tryCloseGroup();
                    }
                }
            }

            private void tryCloseGroup() {
                block1: {
                    block0: {
                        if (!this.isAvailable(this.$outer.out())) break block0;
                        this.emitGroup();
                        break block1;
                    }
                    if (this.pending() == null && !this.finished()) break block1;
                    this.pushEagerly_$eq(true);
                }
            }

            private void emitGroup() {
                this.groupEmitted_$eq(true);
                this.push(this.$outer.out(), this.buf().result());
                this.buf().clear();
                if (!this.finished()) {
                    this.startNewGroup();
                } else if (this.pending() != null) {
                    this.emit(this.$outer.out(), package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pending()})), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.completeStage());
                } else {
                    this.completeStage();
                }
            }

            private void startNewGroup() {
                block3: {
                    block2: {
                        if (this.pending() != null) {
                            this.totalWeight_$eq(this.pendingWeight());
                            this.pendingWeight_$eq(0L);
                            this.buf().$plus$eq(this.pending());
                            this.pending_$eq(null);
                            this.groupEmitted_$eq(false);
                        } else {
                            this.totalWeight_$eq(0L);
                            this.hasElements_$eq(false);
                        }
                        this.pushEagerly_$eq(false);
                        if (!this.isAvailable(this.$outer.in())) break block2;
                        this.nextElement(this.grab(this.$outer.in()));
                        break block3;
                    }
                    if (this.hasBeenPulled(this.$outer.in())) break block3;
                    this.pull(this.$outer.in());
                }
            }

            public void onPush() {
                block0: {
                    if (this.pending() != null) break block0;
                    this.nextElement(this.grab(this.$outer.in()));
                }
            }

            public void onPull() {
                block0: {
                    if (!this.pushEagerly()) break block0;
                    this.emitGroup();
                }
            }

            public void onUpstreamFinish() {
                this.finished_$eq(true);
                if (this.groupEmitted()) {
                    this.completeStage();
                } else {
                    this.tryCloseGroup();
                }
            }

            public void onTimer(Object timerKey) {
                block2: {
                    if (!this.hasElements()) break block2;
                    if (this.isAvailable(this.$outer.out())) {
                        this.emitGroup();
                    } else {
                        this.pushEagerly_$eq(true);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super($outer.shape());
                InHandler.$init$(this);
                OutHandler.$init$(this);
                this.buf = new VectorBuilder();
                this.pending = null;
                this.pendingWeight = 0L;
                this.pushEagerly = false;
                this.groupEmitted = true;
                this.finished = false;
                this.totalWeight = 0L;
                this.hasElements = false;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$emitGroup$1(akka.stream.impl.fusing.GroupedWeightedWithin$$anon$35 )}, serializedLambda);
            }
        };
    }

    public GroupedWeightedWithin(long maxWeight, Function1<T, Object> costFn, FiniteDuration interval) {
        this.maxWeight = maxWeight;
        this.akka$stream$impl$fusing$GroupedWeightedWithin$$costFn = costFn;
        this.interval = interval;
        Predef$.MODULE$.require(maxWeight > 0L, (Function0 & Serializable & scala.Serializable)() -> "maxWeight must be greater than 0");
        Predef$.MODULE$.require(interval.$greater((Object)Duration$.MODULE$.Zero()));
        this.in = Inlet$.MODULE$.apply("in");
        this.out = Outlet$.MODULE$.apply("out");
        this.shape = new FlowShape<T, scala.collection.immutable.Seq<T>>(this.in(), this.out());
    }
}

