/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.concurrent.CompletableFuture;
import jayeson.lib.sports.client.PushDelta;
import jayeson.service.feedwrapper.server.Client;
import jayeson.service.feedwrapper.server.ClientSubscriber;
import jayeson.service.feedwrapper.server.DeltaEventPublisherImpl;
import jayeson.service.feedwrapper.server.SportsConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;

public class ClientSubscriberImpl
implements ClientSubscriber {
    protected static Logger log = LoggerFactory.getLogger(ClientSubscriber.class);
    private Client client;
    private Subscription subscription;
    private DeltaEventPublisherImpl feedHandler;
    private SportsConnector feed;

    @AssistedInject
    public ClientSubscriberImpl(SportsConnector feed, @Assisted Client client) {
        this.client = client;
        this.feed = feed;
    }

    @Override
    public void clientSubscribed() {
        log.info("CLIENT SUBSCRIBED: {}", (Object)this.client.getId());
        this.feedHandler = new DeltaEventPublisherImpl();
        this.subscription = this.feedHandler.subscribe(this);
        this.feed.registerHandler(this.feedHandler);
    }

    @Override
    public void clientUnsubscribed(Throwable cause) {
        log.info("CLIENT UNSUBSCRIBED: {}", (Object)this.client.getId());
        if (this.subscription != null) {
            this.feedHandler.unsubscribe(this.subscription);
            this.feed.deregisterHandler(this.feedHandler);
        }
        this.client = null;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    public void onCompleted() {
    }

    public void onError(Throwable e) {
    }

    public void onNext(PushDelta<?> message) {
        ((CompletableFuture)this.client.send(message).thenAccept(sendResult -> {
            if (!sendResult.booleanValue()) {
                log.info("Cannot send message {} to client. Closing connection now.", (Object)message);
                this.disconnect();
            }
        })).exceptionally(e -> {
            log.error("Cannot send message " + message + " to client. Closing connection now.", e);
            this.disconnect();
            return null;
        });
    }

    private void disconnect() {
        if (this.subscription != null) {
            this.feedHandler.unsubscribe(this.subscription);
            this.feed.deregisterHandler(this.feedHandler);
        }
        this.client.disconnect();
    }
}

