/*
 * Decompiled with CFR 0.152.
 */
package jayeson.service.feedwrapper.server.protocol;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import jayeson.lib.feed.basketball.BasketballEventState;
import jayeson.lib.feed.basketball.BasketballStats;

public class BasketballEventStateEncoder
extends StdSerializer<BasketballEventState> {
    private static final long serialVersionUID = 3276958449322103017L;

    public BasketballEventStateEncoder() {
        this(null);
    }

    public BasketballEventStateEncoder(Class<BasketballEventState> t) {
        super(t);
    }

    public void serialize(BasketballEventState value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("source", value.partitionKey().source());
        gen.writeStringField("segment", value.segment().toString());
        gen.writeNumberField("duration", value.duration());
        gen.writeBooleanField("hasQuarterScore", ((BasketballStats)value.statsOf(0)).hasQuarterScore());
        gen.writeFieldName("eventStats");
        gen.writeStartArray();
        if (((BasketballStats)value.statsOf(0)).getTotalScore() != -1) {
            for (int i = 0; i < 2; ++i) {
                int x;
                gen.writeStartObject();
                if (((BasketballStats)value.statsOf(i)).hasQuarterScore()) {
                    for (x = 1; x < 6; ++x) {
                        if (x == 5) continue;
                        if (((BasketballStats)value.statsOf(i)).getQuarterScore(x) != -1) {
                            gen.writeNumberField("team" + (i + 1) + "Q" + x + "Points", ((BasketballStats)value.statsOf(i)).getQuarterScore(x));
                            continue;
                        }
                        if (((BasketballStats)value.statsOf(i)).getQuarterScore(x) == -1) continue;
                        gen.writeNumberField("team" + (i + 1) + "OtPoints", ((BasketballStats)value.statsOf(i)).getQuarterScore(x));
                    }
                } else {
                    for (x = 1; x < 4; ++x) {
                        if (x == 3) continue;
                        if (((BasketballStats)value.statsOf(i)).getHalfScore(x) != -1) {
                            gen.writeNumberField("team" + (i + 1) + "H" + x + "Points", ((BasketballStats)value.statsOf(i)).getHalfScore(x));
                            continue;
                        }
                        if (((BasketballStats)value.statsOf(i)).getHalfScore(x) == -1) continue;
                        gen.writeNumberField("team" + (i + 1) + "OtPoints", ((BasketballStats)value.statsOf(i)).getHalfScore(x));
                    }
                }
                gen.writeNumberField("team" + (i + 1) + "FtPoints", ((BasketballStats)value.statsOf(i)).getTotalScore());
                gen.writeEndObject();
            }
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }
}

