/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.batch;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.batch.BaseBatchWorkerCallback;
import jayeson.utility.concurrent.worker.batch.BatchProcessor;
import jayeson.utility.concurrent.worker.batch.BatchTask;

class BatchFutureTask<D, V>
extends BatchTask<D, CompletableFuture<V>> {
    private final boolean waitOnFuture;

    public BatchFutureTask(List<D> data, Function<List<D>, CompletableFuture<V>> func, BaseBatchWorkerCallback callback, boolean waitOnFuture) {
        super(data, func, callback);
        this.waitOnFuture = waitOnFuture;
    }

    @Override
    boolean execute(BatchProcessor processor) {
        try {
            CompletableFuture result = (CompletableFuture)this.func.apply(this.data);
            result.whenComplete((u, t) -> {
                try {
                    this.callback.batchProcessed(processor.getWorker(), this.data, u, (Throwable)t);
                }
                finally {
                    if (this.waitOnFuture) {
                        processor.next();
                    }
                }
            });
        }
        catch (Throwable e) {
            this.callback.batchProcessed(processor.getWorker(), this.data, null, e);
        }
        finally {
            if (!this.waitOnFuture) {
                processor.next();
            }
        }
        return true;
    }
}

