/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.batch;

import java.util.List;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.batch.BaseBatchWorkerCallback;
import jayeson.utility.concurrent.worker.batch.BatchProcessor;

class BatchTask<D, V> {
    protected final List<D> data;
    protected final Function<List<D>, V> func;
    protected final BaseBatchWorkerCallback callback;

    BatchTask(List<D> data, Function<List<D>, V> func, BaseBatchWorkerCallback callback) {
        this.data = data;
        this.func = func;
        this.callback = callback;
    }

    boolean execute(BatchProcessor processor) {
        try {
            V result = this.func.apply(this.data);
            this.callback.batchProcessed(processor.getWorker(), this.data, result, null);
        }
        catch (Throwable e) {
            this.callback.batchProcessed(processor.getWorker(), this.data, null, e);
        }
        finally {
            processor.next();
        }
        return true;
    }
}

