/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.batch;

import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.batch.BaseBatchWorkerCallback;
import jayeson.utility.concurrent.worker.batch.BaseSharedExecutorBatchWorker;
import jayeson.utility.concurrent.worker.batch.BatchTask;

public class SharedExecutorBatchWorker<T, U>
extends BaseSharedExecutorBatchWorker<T, U> {
    public SharedExecutorBatchWorker(ScheduledExecutorService executor, Function<List<T>, U> defaultHandler, int maxBatchSize, BatchWorkerCallback<T, U> callback) {
        this(executor, new ConcurrentLinkedQueue(), defaultHandler, maxBatchSize, callback);
    }

    SharedExecutorBatchWorker(ScheduledExecutorService executor, Queue<T> dataQueue, Function<List<T>, U> defaultHandler, int maxBatchSize, BatchWorkerCallback<T, U> callback) {
        super(executor, dataQueue, defaultHandler, maxBatchSize, callback);
        this.defaultHandler = defaultHandler;
    }

    public void submit(T message) {
        if (message == null) {
            throw new IllegalArgumentException("message cannot be null.");
        }
        this.dataQueue.offer(message);
        this.scheduleProcessor(null);
    }

    public void submit(List<T> messages) {
        if (messages == null) {
            throw new IllegalArgumentException("messages cannot be null.");
        }
        if (!messages.isEmpty()) {
            this.dataQueue.addAll(messages);
            this.scheduleProcessor(null);
        }
    }

    @Override
    public BatchTask<T, U> produce(List<T> data, Function<List<T>, U> handler) {
        return new BatchTask<T, U>(data, handler, this.batchWorkerCallback);
    }

    @FunctionalInterface
    public static interface BatchWorkerCallback<T, U>
    extends BaseBatchWorkerCallback<T, U, SharedExecutorBatchWorker<T, U>> {
    }
}

