/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.single;

import java.util.Queue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.single.BaseHandlerFactory;
import jayeson.utility.concurrent.worker.single.Processor;
import jayeson.utility.concurrent.worker.single.Task;

abstract class BaseSharedExecutorWorker<D, V, T extends Task<D, V>, HF extends BaseHandlerFactory<D, V>>
implements BaseHandlerFactory<D, V> {
    protected final Queue<T> taskQueue;
    protected final ScheduledExecutorService executor;
    protected Processor<D, V, T, HF> proccesor;
    protected final Object processorLock = new Object();
    protected volatile Function<D, V> defaultHandler;
    protected volatile HF handlerFactory;

    BaseSharedExecutorWorker(ScheduledExecutorService executor, Queue<T> taskQueue, Function<D, V> defaultHandler, HF handlerFactory) {
        this.taskQueue = taskQueue;
        this.executor = executor;
        this.defaultHandler = defaultHandler;
        this.handlerFactory = handlerFactory;
    }

    public int clear() {
        int removeCount = 0;
        while (!this.taskQueue.isEmpty()) {
            ((Task)this.taskQueue.remove()).getTaskFuture().cancel(false);
            ++removeCount;
        }
        return removeCount;
    }

    public void setDefaultHandler(Function<D, V> defaultHandler) {
        if (defaultHandler == null) {
            throw new IllegalArgumentException("defaultHandler cannot be null. Use removeDefaultHandler if you really mean it.");
        }
        this.defaultHandler = defaultHandler;
        if (!this.taskQueue.isEmpty()) {
            this.scheduleProcessor(null);
        }
    }

    public Function<D, V> getDefaultHandler() {
        return this.defaultHandler;
    }

    public void removeDefaultHandler() {
        this.defaultHandler = null;
    }

    public void setHandlerFactory(HF handlerFactory) {
        if (handlerFactory == null) {
            throw new IllegalArgumentException("handlerFactory cannot be null. Use removeHandlerFactory if you really mean it.");
        }
        this.handlerFactory = handlerFactory;
        if (!this.taskQueue.isEmpty()) {
            this.scheduleProcessor(null);
        }
    }

    public HF getHandlerFactory() {
        return this.handlerFactory;
    }

    public void removeHandlerFactory() {
        this.handlerFactory = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleProcessor(Processor currentProcessor) {
        if (this.proccesor == null) {
            Object object = this.processorLock;
            synchronized (object) {
                if (this.proccesor == null) {
                    this.proccesor = currentProcessor != null ? currentProcessor : new Processor(this, this);
                    this.executor.execute(this.proccesor);
                }
            }
        }
    }

    void next(Processor callingProcessor) {
        this.proccesor = null;
        if (!this.taskQueue.isEmpty()) {
            this.scheduleProcessor(callingProcessor);
        }
    }

    Task<D, V> peek() {
        return (Task)this.taskQueue.peek();
    }

    void remove(Task<D, V> task) {
        this.taskQueue.remove(task);
    }

    void processorDone() {
        this.proccesor = null;
    }
}

