/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.single;

import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.single.SharedExecutorFutureWorker;

public class SharedExecutorFutureWorkerGroup<T, U> {
    protected final ScheduledExecutorService executor;
    protected Function<T, CompletableFuture<U>> defaultHandler;
    protected SharedExecutorFutureWorker.HandlerFactory<T, U> handlerFactory;
    private final ConcurrentHashMap<String, SharedExecutorFutureWorker<T, U>> workers;
    private final boolean waitOnFuture;

    public SharedExecutorFutureWorkerGroup(ScheduledExecutorService executor) {
        this(executor, null, null, true);
    }

    public SharedExecutorFutureWorkerGroup(ScheduledExecutorService executor, boolean waitOnFuture) {
        this(executor, null, null, waitOnFuture);
    }

    public SharedExecutorFutureWorkerGroup(ScheduledExecutorService executor, Function<T, CompletableFuture<U>> defaultHandler) {
        this(executor, defaultHandler, null, true);
    }

    public SharedExecutorFutureWorkerGroup(ScheduledExecutorService executor, Function<T, CompletableFuture<U>> defaultHandler, boolean waitOnFuture) {
        this(executor, defaultHandler, null, waitOnFuture);
    }

    public SharedExecutorFutureWorkerGroup(ScheduledExecutorService executor, SharedExecutorFutureWorker.HandlerFactory<T, U> handlerFactory, boolean waitOnFuture) {
        this(executor, null, handlerFactory, waitOnFuture);
    }

    public SharedExecutorFutureWorkerGroup(ScheduledExecutorService executor, Function<T, CompletableFuture<U>> defaultHandler, SharedExecutorFutureWorker.HandlerFactory<T, U> handlerFactory, boolean waitOnFuture) {
        this.executor = executor;
        this.defaultHandler = defaultHandler;
        this.handlerFactory = handlerFactory;
        this.workers = new ConcurrentHashMap();
        this.waitOnFuture = waitOnFuture;
    }

    public CompletableFuture<U> submit(String streamId, T message, Function<T, CompletableFuture<U>> handler) {
        SharedExecutorFutureWorker worker = this.workers.computeIfAbsent(streamId, id -> this.createNewWorker((String)id));
        return worker.submit(message, handler);
    }

    public CompletableFuture<U> submit(String streamId, T message) {
        SharedExecutorFutureWorker worker = this.workers.computeIfAbsent(streamId, id -> this.createNewWorker((String)id));
        return worker.submit(message);
    }

    public int clear(String streamId) {
        SharedExecutorFutureWorker<T, U> worker = this.workers.get(streamId);
        if (worker != null) {
            return worker.clear();
        }
        return -1;
    }

    public void setDefaultHandler(Function<T, CompletableFuture<U>> defaultHandler) {
        if (defaultHandler == null) {
            throw new IllegalArgumentException("defaultHandler cannot be null.");
        }
        this.defaultHandler = defaultHandler;
        HashSet<SharedExecutorFutureWorker<T, U>> allWorkers = new HashSet<SharedExecutorFutureWorker<T, U>>(this.workers.values());
        for (SharedExecutorFutureWorker sharedExecutorFutureWorker : allWorkers) {
            sharedExecutorFutureWorker.setDefaultHandler(defaultHandler);
        }
    }

    public void removeDefaultHandler() {
        this.defaultHandler = null;
        HashSet<SharedExecutorFutureWorker<T, U>> allWorkers = new HashSet<SharedExecutorFutureWorker<T, U>>(this.workers.values());
        for (SharedExecutorFutureWorker sharedExecutorFutureWorker : allWorkers) {
            sharedExecutorFutureWorker.removeDefaultHandler();
        }
    }

    public void setHandlerFactory(SharedExecutorFutureWorker.HandlerFactory<T, U> handlerFactory) {
        if (handlerFactory == null) {
            throw new IllegalArgumentException("handlerFactory cannot be null.");
        }
        this.handlerFactory = handlerFactory;
        HashSet<SharedExecutorFutureWorker<T, U>> allWorkers = new HashSet<SharedExecutorFutureWorker<T, U>>(this.workers.values());
        for (SharedExecutorFutureWorker sharedExecutorFutureWorker : allWorkers) {
            sharedExecutorFutureWorker.setHandlerFactory(handlerFactory);
        }
    }

    public void removeHandlerFactory() {
        this.handlerFactory = null;
        HashSet<SharedExecutorFutureWorker<T, U>> allWorkers = new HashSet<SharedExecutorFutureWorker<T, U>>(this.workers.values());
        for (SharedExecutorFutureWorker sharedExecutorFutureWorker : allWorkers) {
            sharedExecutorFutureWorker.removeHandlerFactory();
        }
    }

    public int getTotalStreams() {
        return this.workers.size();
    }

    protected SharedExecutorFutureWorker<T, U> createNewWorker(String id) {
        return new SharedExecutorFutureWorker<T, U>(this.executor, this.defaultHandler, this.handlerFactory, this.waitOnFuture);
    }
}

