/*
 * Decompiled with CFR 0.152.
 */
package jayeson.utility.concurrent.worker.single;

import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import jayeson.utility.concurrent.worker.single.SharedExecutorWorker;

public class SharedExecutorWorkerGroup<T, U> {
    protected final ScheduledExecutorService executor;
    protected Function<T, U> defaultHandler;
    protected SharedExecutorWorker.HandlerFactory<T, U> handlerFactory;
    private final ConcurrentHashMap<String, SharedExecutorWorker<T, U>> workers;

    public SharedExecutorWorkerGroup(ScheduledExecutorService executor) {
        this(executor, null, null);
    }

    public SharedExecutorWorkerGroup(ScheduledExecutorService executor, Function<T, U> defaultHandler) {
        this(executor, defaultHandler, null);
    }

    public SharedExecutorWorkerGroup(ScheduledExecutorService executor, SharedExecutorWorker.HandlerFactory<T, U> handlerFactory) {
        this(executor, null, handlerFactory);
    }

    public SharedExecutorWorkerGroup(ScheduledExecutorService executor, Function<T, U> defaultHandler, SharedExecutorWorker.HandlerFactory<T, U> handlerFactory) {
        this.executor = executor;
        this.defaultHandler = defaultHandler;
        this.handlerFactory = handlerFactory;
        this.workers = new ConcurrentHashMap();
    }

    public CompletableFuture<U> submit(String streamId, T message, Function<T, U> handler) {
        SharedExecutorWorker worker = this.workers.computeIfAbsent(streamId, id -> this.createNewWorker((String)id));
        return worker.submit(message, handler);
    }

    public CompletableFuture<U> submit(String streamId, T message) {
        SharedExecutorWorker worker = this.workers.computeIfAbsent(streamId, id -> this.createNewWorker((String)id));
        return worker.submit(message);
    }

    public int clear(String streamId) {
        SharedExecutorWorker<T, U> worker = this.workers.get(streamId);
        if (worker != null) {
            return worker.clear();
        }
        return -1;
    }

    public void setDefaultHandler(Function<T, U> defaultHandler) {
        if (defaultHandler == null) {
            throw new IllegalArgumentException("defaultHandler cannot be null.");
        }
        this.defaultHandler = defaultHandler;
        HashSet<SharedExecutorWorker<T, U>> allWorkers = new HashSet<SharedExecutorWorker<T, U>>(this.workers.values());
        for (SharedExecutorWorker sharedExecutorWorker : allWorkers) {
            sharedExecutorWorker.setDefaultHandler(defaultHandler);
        }
    }

    public void removeDefaultHandler() {
        this.defaultHandler = null;
        HashSet<SharedExecutorWorker<T, U>> allWorkers = new HashSet<SharedExecutorWorker<T, U>>(this.workers.values());
        for (SharedExecutorWorker sharedExecutorWorker : allWorkers) {
            sharedExecutorWorker.removeDefaultHandler();
        }
    }

    public void setHandlerFactory(SharedExecutorWorker.HandlerFactory<T, U> handlerFactory) {
        if (handlerFactory == null) {
            throw new IllegalArgumentException("handlerFactory cannot be null.");
        }
        this.handlerFactory = handlerFactory;
        HashSet<SharedExecutorWorker<T, U>> allWorkers = new HashSet<SharedExecutorWorker<T, U>>(this.workers.values());
        for (SharedExecutorWorker sharedExecutorWorker : allWorkers) {
            sharedExecutorWorker.setHandlerFactory(handlerFactory);
        }
    }

    public void removeHandlerFactory() {
        this.handlerFactory = null;
        HashSet<SharedExecutorWorker<T, U>> allWorkers = new HashSet<SharedExecutorWorker<T, U>>(this.workers.values());
        for (SharedExecutorWorker sharedExecutorWorker : allWorkers) {
            sharedExecutorWorker.removeHandlerFactory();
        }
    }

    public int getTotalStreams() {
        return this.workers.size();
    }

    protected SharedExecutorWorker<T, U> createNewWorker(String id) {
        return new SharedExecutorWorker<T, U>(this.executor, this.defaultHandler, this.handlerFactory);
    }
}

