/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import jayeson.lib.namefeed.DeltaMessages;
import jayeson.lib.namefeed.NameFeedDeltaHelper;
import jayeson.lib.namefeed.NameRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaGenerator {
    final NameFeedDeltaHelper deltaHelper = new NameFeedDeltaHelper();
    Logger log = LoggerFactory.getLogger(this.getClass());

    public DeltaMessages generateDelta(String stream, Map<String, NameRecord> prev, Map<String, NameRecord> curr) {
        Collection<NameRecord> insertedMatches = this.deltaHelper.findInsertedMatch(curr, prev);
        Collection<NameRecord> updatedMatches = this.deltaHelper.findUpdatedMatch(curr, prev);
        Collection<NameRecord> deletedMatches = this.deltaHelper.findDeletedMatch(curr, prev);
        ArrayList<NameRecord> fullMessage = new ArrayList<NameRecord>();
        if (!insertedMatches.isEmpty()) {
            fullMessage.addAll(insertedMatches);
            insertedMatches.stream().forEach(match -> this.log.debug("[INSERT MATCH] {}_{}_{}_{}", new Object[]{match.getOriginalEventId(), match.getLeague(), match.getHost(), match.getGuest()}));
        }
        if (!updatedMatches.isEmpty()) {
            fullMessage.addAll(updatedMatches);
            updatedMatches.stream().forEach(match -> this.log.debug("[Update MATCH] {}_{}_{}_{}", new Object[]{match.getOriginalEventId(), match.getLeague(), match.getHost(), match.getGuest()}));
        }
        deletedMatches.stream().forEach(match -> this.log.debug("[Delete MATCH] {}_{}_{}_{}", new Object[]{match.getOriginalEventId(), match.getLeague(), match.getHost(), match.getGuest()}));
        DeltaMessages msg = new DeltaMessages(fullMessage, deletedMatches);
        return msg;
    }
}

