/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import jayeson.lib.namefeed.NameRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameFeedDeltaHelper {
    Logger log = LoggerFactory.getLogger(this.getClass());

    public Collection<NameRecord> findInsertedMatch(Map<String, NameRecord> current, Map<String, NameRecord> previous) {
        return this.setSubtract(current, previous);
    }

    public Collection<NameRecord> findDeletedMatch(Map<String, NameRecord> current, Map<String, NameRecord> previous) {
        return this.setSubtract(previous, current);
    }

    public Collection<NameRecord> findUpdatedMatch(Map<String, NameRecord> current, Map<String, NameRecord> previous) {
        if (current.size() == 0) {
            return new ArrayList<NameRecord>();
        }
        HashMap currentMap = new HashMap();
        current.entrySet().stream().forEach(set -> currentMap.put(set.getKey(), set.getValue()));
        HashMap previousMap = new HashMap();
        previous.entrySet().stream().forEach(set -> previousMap.put(set.getKey(), set.getValue()));
        currentMap.keySet().retainAll(previousMap.keySet());
        List<NameRecord> currUpdatedMatches = currentMap.values().stream().filter(currResult -> {
            NameRecord prevResult = (NameRecord)previous.get(currResult.getOriginalEventId());
            return prevResult != null && (!currResult.getLeague().equals(prevResult.getLeague()) || !currResult.getHost().equals(prevResult.getHost()) || !currResult.getGuest().equals(prevResult.getGuest()) || currResult.getStartTime() != prevResult.getStartTime());
        }).collect(Collectors.toList());
        return currUpdatedMatches;
    }

    Collection<NameRecord> setSubtract(Map<String, NameRecord> lhs, Map<String, NameRecord> rhs) {
        HashMap left = new HashMap();
        lhs.entrySet().stream().forEach(set -> left.put(set.getKey(), set.getValue()));
        HashMap right = new HashMap();
        rhs.entrySet().stream().forEach(set -> right.put(set.getKey(), set.getValue()));
        left.keySet().removeAll(right.keySet());
        return left.values();
    }

    Map<String, NameRecord> sortById(Set<NameRecord> names) {
        TreeMap<String, NameRecord> result = new TreeMap<String, NameRecord>();
        names.forEach(name -> {
            String key = name.getOriginalEventId();
            result.put(key, (NameRecord)name);
        });
        return result;
    }

    Collection<String> asIds(Set<NameRecord> names) {
        ArrayList<String> ids = new ArrayList<String>();
        names.stream().forEach(name -> ids.add(name.getOriginalEventId()));
        return ids;
    }
}

