/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import jayeson.lib.namefeed.NameFeedServer;
import jayeson.lib.namefeed.ServerConfig;
import jayeson.service.delivery.DeliveryModule;
import jayeson.utility.JacksonConfig;
import jayeson.utility.JacksonConfigFormat;

public class NameFeedServerFactory {
    static final String CONFIG_FILENAME = "nameFeedServer.json";
    static final String CONFIG_VAR_NAME = "nameFeedServerConfFile";

    public NameFeedServer create() {
        return this.create(CONFIG_FILENAME, CONFIG_VAR_NAME);
    }

    public NameFeedServer create(String filename, String path) {
        return this.create(NameFeedServerFactory.searchForConfig(filename, path));
    }

    public NameFeedServer create(ServerConfig config) {
        DeliveryModule deliveryModule;
        if (config == null) {
            throw new IllegalArgumentException("Server config cannot be null");
        }
        try {
            deliveryModule = new DeliveryModule(config.getConfig());
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Cannot create delivery module");
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{deliveryModule});
        return (NameFeedServer)((Object)injector.getInstance(NameFeedServer.class));
    }

    static ServerConfig searchForConfig(String confFilename, String confSysVar) {
        ServerConfig conf = (ServerConfig)JacksonConfig.readConfig((String)confFilename, (String)confSysVar, ServerConfig.class, (JacksonConfigFormat)JacksonConfigFormat.JSON);
        if (conf == null) {
            throw new RuntimeException("Cannot find configuration!! Please check class path");
        }
        return conf;
    }
}

