/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jayeson.lib.namefeed.NameRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameFeedStore {
    final Map<String, ConcurrentHashMap<String, NameRecord>> store;
    private Map<String, Long> ttlCheckMap;
    final Long snapshotExpiryInMilli = 180000L;
    Logger log = LoggerFactory.getLogger(this.getClass());

    public NameFeedStore() {
        this.store = new ConcurrentHashMap<String, ConcurrentHashMap<String, NameRecord>>();
        this.ttlCheckMap = new HashMap<String, Long>();
        this.log.debug("Init name feed store");
        this.startCheckTTL(Executors.newScheduledThreadPool(1));
    }

    public synchronized Map<String, NameRecord> put(String streamName, Collection<NameRecord> names) {
        if (streamName == null) {
            throw new IllegalArgumentException("Stream name cannot be null");
        }
        if (names == null) {
            this.log.error("Name feed is null");
        }
        ConcurrentHashMap nameRecord = new ConcurrentHashMap();
        names.stream().forEach(name -> nameRecord.put(name.getOriginalEventId(), name));
        Map prev = this.store.put(streamName, nameRecord);
        if (prev != null) {
            return new HashMap<String, NameRecord>(prev);
        }
        return new HashMap<String, NameRecord>();
    }

    public synchronized Map<String, NameRecord> get(String streamName) {
        if (streamName == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        Map matches = this.store.get(streamName);
        if (matches != null) {
            return new HashMap<String, NameRecord>(matches);
        }
        return new HashMap<String, NameRecord>();
    }

    public synchronized Map<String, NameRecord> remove(String stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream cannot be null");
        }
        Map matches = this.store.remove(stream);
        if (matches != null) {
            return new HashMap<String, NameRecord>(matches);
        }
        return new HashMap<String, NameRecord>();
    }

    public synchronized void reset(String stream) {
        this.log.debug("reseting {}", (Object)stream);
        this.store.remove(stream);
    }

    private void startCheckTTL(ScheduledExecutorService ttlScheduler) {
        ttlScheduler.scheduleAtFixedRate(() -> this.checkSnapshotExpiry(), 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public synchronized void updateTTLMap(String stream) {
        this.ttlCheckMap.put(stream, System.currentTimeMillis());
    }

    private synchronized void checkSnapshotExpiry() {
        ArrayList removeFromTTL = new ArrayList();
        this.ttlCheckMap.entrySet().forEach(snapshot -> {
            this.log.debug("Checking TTL for stream : {}", snapshot.getKey());
            if (System.currentTimeMillis() - this.snapshotExpiryInMilli > (Long)snapshot.getValue()) {
                this.store.remove(snapshot.getKey());
                this.log.debug("Removing stream {} from snapshot", snapshot.getKey());
                removeFromTTL.add(snapshot.getKey());
            }
        });
        removeFromTTL.stream().forEach(stream -> this.ttlCheckMap.remove(stream));
    }

    public synchronized Set<String> streamSet() {
        return new HashSet<String>(this.store.keySet());
    }

    public synchronized Map<String, Map<String, NameRecord>> getFullSnapshot() {
        HashMap<String, Map<String, NameRecord>> result = new HashMap<String, Map<String, NameRecord>>();
        this.store.entrySet().stream().forEach(stream -> {
            HashMap nameHash = new HashMap();
            ((ConcurrentHashMap)stream.getValue()).entrySet().stream().forEach(name -> nameHash.put(name.getKey(), name.getValue()));
            result.put((String)stream.getKey(), nameHash);
        });
        return result;
    }

    public Map<String, NameRecord> getStore(String stream) {
        return this.store.get(stream);
    }
}

