/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed.client;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.api.messages.IMessageGroupProcessor;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.module.subscriber.ISubscriber;
import jayeson.lib.namefeed.NameFeedStore;
import jayeson.lib.namefeed.NameRecord;
import jayeson.lib.namefeed.codec.NameDeleteMessageClass;
import jayeson.lib.namefeed.codec.NameFullMessageClass;
import jayeson.lib.namefeed.datastructure.NameFeedSet;
import jayeson.lib.namefeed.datastructure.NameRefresh;
import jayeson.lib.namefeed.datastructure.NameReset;
import jayeson.lib.namefeed.message.NameFeedMessageGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NameFeedClient
implements IMessageGroupProcessor,
IEndPointListener {
    final NameFeedStore store;
    private static Logger log = LoggerFactory.getLogger(NameFeedClient.class);
    final List<BiConsumer<String, Collection<NameRecord>>> fullNameFeedHandler = new CopyOnWriteArrayList<BiConsumer<String, Collection<NameRecord>>>();
    final List<BiConsumer<String, Collection<NameRecord>>> deleteNameFeedHandler = new CopyOnWriteArrayList<BiConsumer<String, Collection<NameRecord>>>();
    final List<BiConsumer<String, Collection<NameRecord>>> resetNameFeedHandler = new CopyOnWriteArrayList<BiConsumer<String, Collection<NameRecord>>>();
    final List<BiConsumer<String, Collection<NameRecord>>> refreshNameFeedHandler = new CopyOnWriteArrayList<BiConsumer<String, Collection<NameRecord>>>();
    final ISubscriber delivery;
    final NameFeedMessageGroup msgGroup;

    @Inject
    public NameFeedClient(ISubscriber delivery, NameFeedMessageGroup msgGroup, NameFeedStore store) {
        this.delivery = delivery;
        this.msgGroup = msgGroup;
        this.delivery.attachMessageGroupProcessor((IMessageGroupProcessor)this);
        this.delivery.attachListener((IEndPointListener)this);
        this.store = store;
    }

    public void onStreamFullNameFeed(BiConsumer<String, Collection<NameRecord>> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.fullNameFeedHandler.add(handler);
    }

    public void onStreamDeleteNameFeed(BiConsumer<String, Collection<NameRecord>> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.deleteNameFeedHandler.add(handler);
    }

    public void onStreamResetNameFeed(BiConsumer<String, Collection<NameRecord>> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.resetNameFeedHandler.add(handler);
    }

    public void onStreamRefreshNameFeed(BiConsumer<String, Collection<NameRecord>> handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        this.refreshNameFeedHandler.add(handler);
    }

    public void start() {
        this.delivery.startConsuming();
    }

    public void stop() {
    }

    public void process(MessageWrapper mw) throws Exception {
        if (mw.msg() instanceof NameReset) {
            NameReset resetMsg = (NameReset)mw.msg();
            log.debug("Reseting stream {}", (Object)resetMsg.getStream());
            this.store.reset(resetMsg.getStream());
            this.emitResetNameFeed(resetMsg.getStream(), new ArrayList<NameRecord>());
            return;
        }
        if (mw.msg() instanceof NameRefresh) {
            NameRefresh refreshMsg = (NameRefresh)mw.msg();
            log.debug("Refreshing stream {}", (Object)refreshMsg.getStream());
            this.store.updateTTLMap(refreshMsg.getStream());
            this.emitRefreshNameFeed(refreshMsg.getStream(), new ArrayList<NameRecord>());
            return;
        }
        if (!(mw.msg() instanceof NameFeedSet)) {
            log.error("Received unknown message " + mw.msg());
            return;
        }
        NameFeedSet msg = (NameFeedSet)mw.msg();
        String stream = msg.getStreamName();
        IMessageClass msgCls = mw.getMessageClass();
        if (msgCls instanceof NameFullMessageClass) {
            if (this.store.get(stream).isEmpty()) {
                this.store.put(stream, msg.getNameFeedRecords());
                msg.getNameFeedRecords().stream().forEach(name -> log.debug("Inserting name feed {}_{}_{}_{}_{}_{}_{} Stream : {}", new Object[]{name.getSource(), name.getOriginalEventId(), name.getLeague(), name.getHost(), name.getGuest(), name.getOddType(), name.getSportType(), stream}));
            } else {
                msg.getNameFeedRecords().stream().forEach(name -> {
                    this.store.getStore(stream).put(name.getOriginalEventId(), (NameRecord)name);
                    log.debug("Inserting name feed {}_{}_{}_{}_{}_{}_{} Stream : {}", new Object[]{name.getSource(), name.getOriginalEventId(), name.getLeague(), name.getHost(), name.getGuest(), name.getOddType(), name.getSportType(), stream});
                });
            }
            this.emitFullNameFeed(stream, msg.getNameFeedRecords());
        }
        if (msgCls instanceof NameDeleteMessageClass) {
            msg.getNameFeedRecords().stream().forEach(name -> {
                if (this.store.getStore(stream) == null || this.store.getStore(stream).size() == 0) {
                    if (this.store.getStore(stream) == null) {
                        log.error("Store does not contain stream, Stream: {}", (Object)stream);
                    }
                    log.error("Deleting name from a empty map!");
                    return;
                }
                this.store.getStore(stream).remove(name.getOriginalEventId());
                log.debug("Deleting name feed {}_{}_{}_{}_{}_{} Stream : {}", new Object[]{name.getSource(), name.getOriginalEventId(), name.getLeague(), name.getHost(), name.getGuest(), name.getOddType(), stream});
            });
            this.emitDeltaNameFeed(stream, msg.getNameFeedRecords());
        }
    }

    private void print(NameFeedSet msg) {
        msg.getNameFeedRecords().stream().forEach(r -> log.debug(msg.getSportType() + " " + r.getOriginalEventId() + " " + msg.getSource() + " " + r.getLeague() + " " + r.getHost() + " " + r.getGuest()));
    }

    public Map<String, Map<String, NameRecord>> getFullSnapshot() {
        return this.store.getFullSnapshot();
    }

    void emitFullNameFeed(String stream, Collection<NameRecord> nameFeed) {
        this.fullNameFeedHandler.stream().forEach(cb -> cb.accept(stream, nameFeed));
    }

    void emitDeltaNameFeed(String stream, Collection<NameRecord> nameFeed) {
        this.deleteNameFeedHandler.stream().forEach(cb -> cb.accept(stream, nameFeed));
    }

    void emitResetNameFeed(String stream, Collection<NameRecord> nameFeed) {
        this.resetNameFeedHandler.stream().forEach(cb -> cb.accept(stream, nameFeed));
    }

    void emitRefreshNameFeed(String stream, Collection<NameRecord> nameFeed) {
        this.refreshNameFeedHandler.stream().forEach(cb -> cb.accept(stream, nameFeed));
    }

    public IMessageGroup messageGroup() {
        return this.msgGroup;
    }

    public void onDeregistered(IEndPoint arg0) {
    }

    public void onRegistered(IEndPoint arg0) {
    }

    public void onEvent(EPEvent arg0) {
    }
}

