/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed.client;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import jayeson.lib.delivery.module.subscriber.StandAloneSubscriberModule;
import jayeson.lib.namefeed.client.ClientConfig;
import jayeson.lib.namefeed.client.ClientModule;
import jayeson.lib.namefeed.client.NameFeedClient;
import jayeson.utility.JacksonConfig;
import jayeson.utility.JacksonConfigFormat;

@Singleton
public class NameFeedClientFactory {
    static final String CONFIG_FILENAME = "namefeedClient.json";
    static final String CONFIG_VAR_NAME = "namefeedClientConfFile";

    public NameFeedClient create() {
        return this.create(CONFIG_FILENAME, CONFIG_VAR_NAME);
    }

    public NameFeedClient create(String filename, String path) {
        ClientConfig config = NameFeedClientFactory.searchForConfig(filename, path);
        if (config == null) {
            return null;
        }
        return this.create(NameFeedClientFactory.searchForConfig(filename, path));
    }

    public NameFeedClient create(ClientConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Client config cannot be null");
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new StandAloneSubscriberModule(config.getConfig()), new ClientModule()});
        return (NameFeedClient)injector.getInstance(NameFeedClient.class);
    }

    static ClientConfig searchForConfig(String confFilename, String confSysVar) {
        ClientConfig conf = (ClientConfig)JacksonConfig.readConfig((String)confFilename, (String)confSysVar, ClientConfig.class, (JacksonConfigFormat)JacksonConfigFormat.JSON);
        if (conf == null) {
            return null;
        }
        return conf;
    }
}

