/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.namefeed.codec;

import com.google.protobuf.MessageLite;
import com.google.protobuf.ProtocolStringList;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.core.messages.BaseMessageClass;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.namefeed.NameOddType;
import jayeson.lib.namefeed.NameRecord;
import jayeson.lib.namefeed.codec.StringPool;
import jayeson.lib.namefeed.datastructure.NameFeedSet;
import jayeson.lib.namefeed.protobuf.NameFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameDeleteMessageClass
extends BaseMessageClass<NameRecord> {
    final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    final List<ChannelHandler> decoders = new ArrayList<ChannelInboundHandlerAdapter>(Arrays.asList(new ChannelInboundHandlerAdapter[]{new ProtobufDecoder((MessageLite)NameFeed.NameFeedCol.getDefaultInstance()), new Decoder()}));
    final List<ChannelHandler> encoders = new ArrayList<ChannelOutboundHandlerAdapter>(Arrays.asList(new ChannelOutboundHandlerAdapter[]{new Encoder(), new ProtobufEncoder()}));

    public NameDeleteMessageClass(IMessageGroup group, byte id) {
        super(NameRecord.class, group, id);
    }

    public List<ChannelHandler> inboundHandlers(Channel arg0) {
        return this.decoders;
    }

    public List<ChannelHandler> outboundHandlers(Channel arg0) {
        return this.encoders;
    }

    public Object write(NameFeedSet msg) {
        String source = msg.getSource();
        StringPool pool = new StringPool();
        NameFeed.NameFeedCol.Builder builder = NameFeed.NameFeedCol.newBuilder();
        try {
            int srcIndex = pool.getIndexOf(source);
            builder.setSource(srcIndex);
            msg.getNameFeedRecords().forEach(name -> {
                this.log.debug("Sending delete message {}_{}", (Object)name.getSource(), (Object)name.getOriginalEventId());
                builder.addNames(NameDeleteMessageClass.writeName(name));
            });
        }
        catch (Exception e) {
            this.log.debug(e.getMessage() + " | " + Arrays.asList(e.getStackTrace()));
        }
        builder.addAllStringPool(pool.getAll());
        builder.setSportType(NameFeed.NameFeedSportType.valueOf(msg.getSportType().name()));
        builder.setOddType(NameFeed.NameFeedOddType.valueOf(msg.getOddType().name()));
        return builder.build();
    }

    static NameFeed.EventName writeName(NameRecord msg) {
        NameFeed.EventName.Builder builder = NameFeed.EventName.newBuilder();
        builder.setOriginalEventId(msg.getOriginalEventId());
        builder.setLeague("");
        builder.setHost("");
        builder.setGuest("");
        builder.setStartTime(0L);
        builder.setEpoch(0L);
        builder.setSource(msg.getSource());
        builder.setOddType(NameFeed.NameFeedOddType.valueOf(msg.getOddType().name()));
        builder.setSportType(NameFeed.NameFeedSportType.valueOf(msg.getSportType().name()));
        return builder.build();
    }

    public NameFeedSet read(Object msg) {
        NameFeed.NameFeedCol input = (NameFeed.NameFeedCol)msg;
        List<NameFeed.EventName> matches = input.getNamesList();
        ProtocolStringList pool = input.getStringPoolList();
        String source = (String)pool.get(input.getSource());
        List<NameRecord> matchesOut = matches.stream().map(pb -> NameDeleteMessageClass.readName(source, pb)).collect(Collectors.toList());
        String sportType = input.getSportType().toString();
        String oddType = input.getOddType().toString();
        return new NameFeedSet("NF_" + sportType + "_" + source + "_" + oddType, matchesOut);
    }

    static NameRecord readName(String source, NameFeed.EventName msg) {
        NameFeed.EventName message = msg;
        NameRecord namefeed = new NameRecord();
        namefeed.setOriginalEventId(message.getOriginalEventId());
        namefeed.setSportType(SportType.valueOf((String)message.getSportType().name()));
        namefeed.setSource(message.getSource());
        namefeed.setOddType(NameOddType.valueOf((String)message.getOddType().name()));
        return namefeed;
    }

    @ChannelHandler.Sharable
    class Decoder
    extends ChannelInboundHandlerAdapter {
        Decoder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            NameFeedSet output = NameDeleteMessageClass.this.read(msg);
            ctx.fireChannelRead((Object)output);
        }
    }

    @ChannelHandler.Sharable
    class Encoder
    extends ChannelOutboundHandlerAdapter {
        Encoder() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Object output = NameDeleteMessageClass.this.write((NameFeedSet)msg);
            ctx.write(output, promise);
        }
    }
}

