/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.client;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.core.Snapshot;
import jayeson.lib.sports.client.DeltaEventHandler;
import jayeson.lib.sports.client.MemoryDispatcher;
import jayeson.lib.sports.client.MemoryDispatcherFactory;
import jayeson.lib.sports.core.FSRepo;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroupManager;
import jayeson.lib.sports.receive.StreamCommandProcessor;
import jayeson.model.IDataFilter;
import jayeson.model.IFilterEvent;
import jayeson.model.IFilterEventDispatcher;
import jayeson.model.IFilterEventListener;
import jayeson.model.filter.FilterableSnapshot;
import jayeson.model.filter.GeneralDataFilter;
import jayeson.model.filter.event.FilterRequestUpdateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedView<M extends IBetMatch>
implements IFilterEventListener {
    private static Logger log = LoggerFactory.getLogger(FeedView.class);
    private FSRepo fsRepo;
    private MemoryDispatcherFactory factory;
    private IEndPointGroupManager epgm;
    private IDataFilter filter;
    private Class<M> matchClass;
    Map<DeltaEventHandler, IEndPointDispatcher> handlers;

    @Inject
    public FeedView(IEndPointGroupManager manager, MemoryDispatcherFactory factory, StreamCommandProcessor scp) {
        this.factory = factory;
        this.fsRepo = scp.getFSRepo("MEMORY_AGGREGATED_STREAM");
        this.epgm = manager;
        this.handlers = new HashMap<DeltaEventHandler, IEndPointDispatcher>();
    }

    FeedView(FeedView<?> view, IDataFilter filter, Class<M> clazz) {
        this.factory = view.factory;
        this.fsRepo = view.fsRepo;
        this.epgm = view.epgm;
        this.handlers = new HashMap<DeltaEventHandler, IEndPointDispatcher>();
        if (filter != null) {
            this.setFilter(filter);
        }
        this.matchClass = clazz;
    }

    protected void setFilter(IDataFilter filter) {
        this.filter = filter;
        if (filter.isRunnable() && filter instanceof IFilterEventDispatcher) {
            this.registerDispatcher((IFilterEventDispatcher)filter);
        }
    }

    public void cleanUp() {
        ArrayList<DeltaEventHandler> registeredHandlers = new ArrayList<DeltaEventHandler>(this.handlers.keySet());
        registeredHandlers.stream().forEach(handler -> this.unregister((DeltaEventHandler)handler));
        if (this.filter.isRunnable() && this.filter instanceof IFilterEventDispatcher) {
            this.deregisterDispatcher((IFilterEventDispatcher)this.filter);
        }
    }

    public ISnapshot<M> snapshot() {
        try {
            Collection matches = this.fsRepo.getSnapshot().matches().parallelStream().filter(match -> this.matchClass.isInstance(match)).collect(Collectors.toList());
            if (this.filter == null) {
                return new Snapshot(matches);
            }
            return new FilterableSnapshot(matches, this.filter);
        }
        catch (Exception exp) {
            log.error("Exception while getting feedview snapshot", (Throwable)exp);
            return null;
        }
    }

    public <E extends IBetEvent, R extends IBetRecord> void register(DeltaEventHandler<M, E, R> listener) {
        if (this.handlers.containsKey(listener)) {
            log.error("Handler already registered.");
            return;
        }
        MemoryDispatcher disp = (MemoryDispatcher)this.factory.createEPD(listener);
        disp.setMatchClass(this.matchClass);
        this.epgm.registerEPD(disp, this.filter);
        this.handlers.put(listener, disp);
    }

    public <E extends IBetEvent, R extends IBetRecord> void unregister(DeltaEventHandler<M, E, R> listener) {
        IEndPointDispatcher disp = this.handlers.remove(listener);
        if (disp != null) {
            this.epgm.deregisterEPD(disp);
        }
    }

    @Subscribe
    public void handlerFilterEvent(IFilterEvent event) {
        if (!(event instanceof FilterRequestUpdateEvent)) {
            return;
        }
        FilterRequestUpdateEvent filterRequestUpdateEvent = (FilterRequestUpdateEvent)event;
        GeneralDataFilter oldFilter = filterRequestUpdateEvent.getOldFilter();
        if (oldFilter.isRunnable() && oldFilter instanceof IFilterEventDispatcher) {
            this.deregisterDispatcher((IFilterEventDispatcher)oldFilter);
        }
        GeneralDataFilter newFilter = filterRequestUpdateEvent.getNewFilter();
        this.setFilter((IDataFilter)newFilter);
    }

    public IDataFilter getFilter() {
        return this.filter;
    }
}

