/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.client;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetEventState;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.sports.client.DeleteEvent;
import jayeson.lib.sports.client.DeleteMatch;
import jayeson.lib.sports.client.DeleteOdd;
import jayeson.lib.sports.client.DeltaEventHandler;
import jayeson.lib.sports.client.InsertEvent;
import jayeson.lib.sports.client.InsertMatch;
import jayeson.lib.sports.client.InsertOdd;
import jayeson.lib.sports.client.InternalDeltaEventHandler;
import jayeson.lib.sports.client.Reset;
import jayeson.lib.sports.client.UpdateEvent;
import jayeson.lib.sports.client.UpdateMatch;
import jayeson.lib.sports.client.UpdateOdd;
import jayeson.lib.sports.core.FSRepo;
import jayeson.lib.sports.core.SnapshotUtil;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.datastructure.OutgoingImpl;
import jayeson.lib.sports.dispatch.AbstractComparableEPDispatcher;
import jayeson.lib.sports.receive.StreamCommandProcessor;

public class MemoryDispatcher<M extends IBetMatch>
extends AbstractComparableEPDispatcher {
    public static final String MEMORY_STREAM = "MEMORY_AGGREGATED_STREAM";
    private DeltaEventHandler<IBetMatch, IBetEvent, IBetRecord> handler;
    private String id;
    IndexedSnapshot lastPushedSs = IndexedSnapshotImpl.EMPTY_SNAPSHOT;
    private StreamCommandProcessor scp;
    private Class<M> matchSportTypeClass;

    @Inject
    public MemoryDispatcher(StreamCommandProcessor scp, ScheduledExecutorService es, SportsFeedMessageGroup grp, @Assisted DeltaEventHandler<IBetMatch, IBetEvent, IBetRecord> handler) {
        super(MEMORY_STREAM, grp, es);
        this.handler = handler;
        this.id = UUID.randomUUID().toString();
        this.scp = scp;
    }

    @Override
    public String id() {
        return this.id;
    }

    public void setMatchClass(Class<M> matchClass) {
        this.matchSportTypeClass = matchClass;
    }

    @Override
    protected void handleMessage(Outgoing out) {
        if (!this.isInitialized().getNow(false).booleanValue()) {
            return;
        }
        if (this.grp.isIndicatorMessage(out.msgType())) {
            if (out.msgType() == this.grp.SWITCH_FILTER_START) {
                int requestId = Integer.parseInt(((OutgoingImpl)out).msg().toString());
                this.pushSwitchFilterStart(requestId);
            } else if (out.msgType() == this.grp.SWITCH_FILTER_END) {
                this.pushSwitchFilterEnd();
            } else if (out.msgType() == this.grp.FULLSNAPSHOT_START || out.msgType() == this.grp.TTL_RESTORE_START) {
                this.pushFullSnapshotStart();
            } else if (out.msgType() == this.grp.FULLSNAPSHOT_END || out.msgType() == this.grp.TTL_RESTORE_END) {
                this.pushFullSnapshotEnd();
            } else if (out.msgType() == this.grp.SWITCH_FILTER_FAIL) {
                int requestId = Integer.parseInt(((OutgoingImpl)out).msg().toString());
                this.pushSwitchFilterFail(requestId);
            }
        } else {
            DeltaOutgoing deltaOut = (DeltaOutgoing)out;
            if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_INSERT_MATCH)) {
                this.lastPushedSs = this.pushInsertMatch(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_INSERT_EVENT)) {
                this.lastPushedSs = this.pushInsertEvent(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_INSERT_ODD)) {
                this.lastPushedSs = this.pushInsertOdd(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_UPDATE_MATCH)) {
                this.lastPushedSs = this.pushUpdateMatch(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_UPDATE_EVENT)) {
                this.lastPushedSs = this.pushUpdateEvent(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_UPDATE_ODD)) {
                this.lastPushedSs = this.pushUpdateOdd(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_DELETE_MATCH)) {
                this.lastPushedSs = this.pushDeleteMatch(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_DELETE_EVENT)) {
                this.lastPushedSs = this.pushDeleteEvent(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_DELETE_ODD)) {
                this.lastPushedSs = this.pushDeleteOdd(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.DATA_RESET)) {
                this.lastPushedSs = this.pushReset(deltaOut);
            } else if (this.isSame(out.msgType(), (IMessageClass<?>)this.grp.ADMIN_REFRESH)) {
                this.pushRefresh(deltaOut);
            }
        }
    }

    private void pushSwitchFilterFail(int requestId) {
        if (this.handler instanceof InternalDeltaEventHandler) {
            ((InternalDeltaEventHandler)this.handler).onSwitchFilterFail(requestId);
        } else {
            this.handler.onSwitchFilterFail();
        }
    }

    private void pushSwitchFilterStart(int requestId) {
        if (this.handler instanceof InternalDeltaEventHandler) {
            ((InternalDeltaEventHandler)this.handler).onSwitchFilterStart(requestId);
        } else {
            this.handler.onSwitchFilterStart();
        }
    }

    private void pushSwitchFilterEnd() {
        this.handler.onSwitchFilterEnd();
    }

    private void pushFullSnapshotStart() {
        this.handler.onFullSnapshotStart();
    }

    private void pushFullSnapshotEnd() {
        this.handler.onFullSnapshotEnd();
    }

    private IndexedSnapshot pushReset(DeltaOutgoing out) {
        IndexedSnapshot after = null;
        IndexedSnapshot delta = this.filter(out.delta());
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        Reset reset = new Reset((ISnapshot<? extends IBetMatch>)after, (Collection<PartitionKey>)delta.getPartitions());
        this.handler.onReset(reset);
        return after;
    }

    protected void pushRefresh(DeltaOutgoing out) {
        ArrayList<PartitionKey> keys = new ArrayList<PartitionKey>(out.delta().getPartitions());
        this.handler.onRefresh(keys);
    }

    protected IndexedSnapshot pushInsertMatch(DeltaOutgoing out) {
        IndexedSnapshot delta = this.filter(out.delta());
        Collection matchesList = delta.matches();
        IndexedSnapshot after = null;
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        if (!matchesList.isEmpty()) {
            InsertMatch im = new InsertMatch((ISnapshot<? extends IBetMatch>)((ISnapshot<IBetMatch>)((ISnapshot<? extends IBetMatch>)after)), matchesList);
            this.handler.onInsertMatch(im);
        }
        return after;
    }

    protected IndexedSnapshot pushInsertEvent(DeltaOutgoing out) {
        IndexedSnapshot delta = this.filter(out.delta());
        IndexedSnapshot after = null;
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        Collection<IBetEvent> eventsList = this.events(delta.matches());
        if (!eventsList.isEmpty()) {
            InsertEvent<IBetEvent> ie = new InsertEvent<IBetEvent>((ISnapshot<IBetMatch>)((ISnapshot<? extends IBetMatch>)after), eventsList);
            this.handler.onInsertEvent(ie);
        }
        return after;
    }

    protected IndexedSnapshot pushInsertOdd(DeltaOutgoing out) {
        IndexedSnapshot delta = this.filter(out.delta());
        IndexedSnapshot after = null;
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        Collection<IBetRecord> recordsList = this.records(this.events(delta.matches()));
        if (!recordsList.isEmpty()) {
            InsertOdd<IBetRecord> io = new InsertOdd<IBetRecord>((ISnapshot<IBetMatch>)((ISnapshot<? extends IBetMatch>)after), recordsList);
            this.handler.onInsertOdd(io);
        }
        return after;
    }

    protected IndexedSnapshot pushUpdateMatch(DeltaOutgoing out) {
        IndexedSnapshot delta = this.filter(out.delta());
        IndexedSnapshot after = null;
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        Collection matchesList = delta.matches();
        if (!matchesList.isEmpty()) {
            UpdateMatch um = new UpdateMatch((ISnapshot<? extends IBetMatch>)((ISnapshot<IBetMatch>)((ISnapshot<? extends IBetMatch>)after)), matchesList);
            this.handler.onUpdateMatch(um);
        }
        return after;
    }

    protected IndexedSnapshot pushUpdateEvent(DeltaOutgoing out) {
        IndexedSnapshot delta = this.filter(out.delta());
        IndexedSnapshot after = null;
        ArrayList<IBetEvent> eventsList = new ArrayList<IBetEvent>();
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        for (IBetEvent event : this.events(delta.matches())) {
            eventsList.add(after.match(event.matchId()).event(event.id()));
        }
        if (!eventsList.isEmpty()) {
            UpdateEvent ue = new UpdateEvent((ISnapshot<? extends IBetMatch>)((ISnapshot<IBetMatch>)((ISnapshot<? extends IBetMatch>)after)), eventsList);
            this.handler.onUpdateEvent(ue);
        }
        return after;
    }

    protected IndexedSnapshot pushUpdateOdd(DeltaOutgoing out) {
        IndexedSnapshot delta = this.filter(out.delta());
        IndexedSnapshot after = null;
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        Collection<IBetRecord> recordsList = this.records(this.events(delta.matches()));
        if (!recordsList.isEmpty()) {
            UpdateOdd<IBetRecord> uo = new UpdateOdd<IBetRecord>((ISnapshot<IBetMatch>)((ISnapshot<? extends IBetMatch>)after), recordsList);
            this.handler.onUpdateOdd(uo);
        }
        return after;
    }

    protected IndexedSnapshot pushDeleteMatch(DeltaOutgoing out) {
        IndexedSnapshot delta = this.filter(out.delta());
        IndexedSnapshot after = null;
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        Collection matchesList = delta.matches();
        if (!matchesList.isEmpty()) {
            DeleteMatch im = new DeleteMatch((ISnapshot<? extends IBetMatch>)((ISnapshot<IBetMatch>)((ISnapshot<? extends IBetMatch>)after)), matchesList);
            this.handler.onDeleteMatch(im);
        }
        return after;
    }

    protected IndexedSnapshot pushDeleteEvent(DeltaOutgoing out) {
        IndexedSnapshot delta = this.filter(out.delta());
        IndexedSnapshot after = null;
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        Collection<IBetEvent> eventsList = this.events(delta.matches());
        if (!eventsList.isEmpty()) {
            DeleteEvent<IBetEvent> ie = new DeleteEvent<IBetEvent>((ISnapshot<IBetMatch>)((ISnapshot<? extends IBetMatch>)after), eventsList);
            this.handler.onDeleteEvent(ie);
        }
        return after;
    }

    protected IndexedSnapshot pushDeleteOdd(DeltaOutgoing out) {
        IndexedSnapshot delta = this.filter(out.delta());
        IndexedSnapshot after = null;
        after = out.after() != null ? this.filter(out.after()) : SnapshotUtil.combineSnapshots(out.msgType(), delta, this.lastPushedSs).getAfterSs();
        Collection<IBetRecord> recordsList = this.records(this.events(delta.matches()));
        if (!recordsList.isEmpty()) {
            DeleteOdd<IBetRecord> delo = new DeleteOdd<IBetRecord>((ISnapshot<IBetMatch>)((ISnapshot<? extends IBetMatch>)after), recordsList);
            this.handler.onDeleteOdd(delo);
        }
        return after;
    }

    protected Collection<IBetEvent> events(Collection<IBetMatch> matches) {
        ArrayList<IBetEvent> events = new ArrayList<IBetEvent>();
        for (IBetMatch match : matches) {
            events.addAll(match.events());
        }
        return events;
    }

    protected Collection<IBetRecord> records(Collection<IBetEvent> events) {
        ArrayList<IBetRecord> records = new ArrayList<IBetRecord>();
        for (IBetEvent evt : events) {
            records.addAll(evt.records());
        }
        return records;
    }

    protected Collection<IBetEventState> states(Collection<IBetEvent> events) {
        ArrayList<IBetEventState> states = new ArrayList<IBetEventState>();
        for (IBetEvent evt : events) {
            states.addAll(evt.eventStates());
        }
        return states;
    }

    protected boolean isSame(IMessageClass<?> lhs, IMessageClass<?> rhs) {
        return lhs.isSameFormat(rhs);
    }

    @Override
    public CompletableFuture<Boolean> isInitialized() {
        FSRepo fsRepo = this.scp.getFSRepo(MEMORY_STREAM);
        return fsRepo.isReady(this.getStream());
    }

    protected Collection<M> filter(Collection<IBetMatch> inputCollection) {
        if (this.matchSportTypeClass == IBetMatch.class || this.matchSportTypeClass == null) {
            return inputCollection;
        }
        Collection matches = inputCollection.parallelStream().filter((? super T match) -> this.matchSportTypeClass.isInstance(match)).collect(Collectors.toList());
        return matches;
    }

    protected IndexedSnapshot filter(IndexedSnapshot snapshot) {
        return new IndexedSnapshotImpl(this.filter(snapshot.matches()), snapshot.getPartitionMap());
    }
}

