/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.client;

import java.util.Collection;
import java.util.Iterator;
import jayeson.lib.feed.api.IBetEvent;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.IBetRecord;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.api.twoside.IB2Record;
import jayeson.lib.sports.client.FeedView;
import jayeson.lib.sports.client.PushModeHandler;
import jayeson.lib.sports.client.SportsFeedClient;
import jayeson.lib.sports.client.SportsFeedFactory;

public class SportsFeedSubscriber {
    public static void main(String[] args) throws InterruptedException {
        SportsFeedFactory factory = new SportsFeedFactory();
        SportsFeedClient client = factory.createFromConfigFile("conf/libSportConfig.json");
        client.getSubscriber().startConsuming();
        FeedView<IBetMatch> noFilterview = client.view(IBetMatch.class);
        PushModeHandler hdpListener = new PushModeHandler("hdpfiltered");
        noFilterview.register(hdpListener);
        while (true) {
            ISnapshot<IBetMatch> snapshot = noFilterview.snapshot();
            Collection matches = snapshot.matches();
            System.out.println("Found " + matches.size() + " Matches");
            System.out.println("======================");
            Thread.sleep(5000L);
        }
    }

    public static <M extends IBetMatch> void printMatches(Collection<M> matches) {
        int limit = 3;
        Iterator<M> it = matches.iterator();
        for (int i = 0; i < limit && it.hasNext(); ++i) {
            IBetMatch match = (IBetMatch)it.next();
            System.out.println("-------------------------");
            System.out.println(match.sportType() + ":" + match.league() + ":" + (String)match.participants().get(0) + ":" + (String)match.participants().get(1));
            SportsFeedSubscriber.printEvents(match.events());
        }
    }

    public static <E extends IBetEvent> void printEvents(Collection<E> events) {
        int limit = 1;
        Iterator<E> it = events.iterator();
        for (int i = 0; i < limit && it.hasNext(); ++i) {
            IBetEvent event = (IBetEvent)it.next();
            SportsFeedSubscriber.printRecords(event.records());
        }
    }

    public static <R extends IBetRecord> void printRecords(Collection<R> records) {
        int limit = 3;
        Iterator<R> it = records.iterator();
        for (int i = 0; i < limit && it.hasNext(); ++i) {
            IBetRecord record = (IBetRecord)it.next();
            System.out.println(record.source() + ":" + ((IB2Record)record).pivotType() + ":" + ((IB2Record)record).rateOver() + ":" + ((IB2Record)record).rateUnder() + ":" + ((IB2Record)record).rateEqual());
        }
    }
}

