/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Comparator;
import java.util.List;

class ColumnComparator<T extends Message>
implements Comparator<T> {
    final List<String> columns;

    public ColumnComparator(List<String> columns) {
        this.columns = columns;
    }

    @Override
    public int compare(T lhs, T rhs) {
        for (String column : this.columns) {
            int fieldCompare;
            Descriptors.FieldDescriptor leftType = lhs.getDescriptorForType().findFieldByName(column);
            Object leftField = lhs.getField(leftType);
            Object rightField = rhs.getField(leftType);
            switch (leftType.getType()) {
                case ENUM: {
                    Descriptors.EnumValueDescriptor lhsEnum = (Descriptors.EnumValueDescriptor)leftField;
                    Descriptors.EnumValueDescriptor rhsEnum = (Descriptors.EnumValueDescriptor)rightField;
                    if (lhsEnum.getNumber() < rhsEnum.getNumber()) {
                        fieldCompare = -1;
                        break;
                    }
                    if (lhsEnum.getNumber() == rhsEnum.getNumber()) {
                        fieldCompare = 0;
                        break;
                    }
                    fieldCompare = 1;
                    break;
                }
                case DOUBLE: 
                case FLOAT: 
                case INT64: 
                case UINT64: 
                case INT32: 
                case FIXED64: 
                case FIXED32: 
                case BOOL: 
                case STRING: 
                case BYTES: 
                case UINT32: 
                case SFIXED32: 
                case SFIXED64: 
                case SINT32: 
                case SINT64: {
                    Comparable lhsField = (Comparable)leftField;
                    fieldCompare = lhsField.compareTo(rightField);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Field recycler cannot sort non primitive types");
                }
            }
            if (fieldCompare == 0) continue;
            return fieldCompare;
        }
        return 0;
    }
}

