/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jayeson.lib.delivery.api.messages.IMessageGroup;
import jayeson.lib.delivery.core.messages.JSonBaseMessageClass;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.sports.codec.RefreshMessage;
import jayeson.lib.sports.datastructure.DataMessageWrapper;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshMessageClass
extends JSonBaseMessageClass<RefreshMessage> {
    private static Logger log = LoggerFactory.getLogger(RefreshMessageClass.class);
    protected PreProcessOutHandler preProcessOutH = new PreProcessOutHandler();
    protected PostProcessInHandler postProcessInH = new PostProcessInHandler();

    public RefreshMessageClass(IMessageGroup group, byte id, ObjectMapper mapper) {
        super(group, RefreshMessage.class, id, mapper);
    }

    public List<ChannelHandler> inboundHandlers(Channel c) {
        return Arrays.asList(new ChannelHandler[]{this.inH, this.postProcessInH});
    }

    public List<ChannelHandler> outboundHandlers(Channel c) {
        return Arrays.asList(new ChannelHandler[]{this.preProcessOutH, this.outH});
    }

    @ChannelHandler.Sharable
    private class PreProcessOutHandler
    extends ChannelOutboundHandlerAdapter {
        private PreProcessOutHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Object out = msg;
            if (msg instanceof DataMessageWrapper) {
                DataMessageWrapper dataMessageWrapper = (DataMessageWrapper)msg;
                IndexedSnapshot ds = dataMessageWrapper.delta();
                out = new RefreshMessage();
                Set<String> parts = ds.getPartitions().stream().map(PartitionKey::toString).collect(Collectors.toSet());
                ((RefreshMessage)out).setPartitionKeys(parts);
            } else {
                log.warn("UnExpected outgoing type", msg);
            }
            ctx.write(out, promise);
        }
    }

    @ChannelHandler.Sharable
    private class PostProcessInHandler
    extends ChannelInboundHandlerAdapter {
        private PostProcessInHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Object out = msg;
            if (msg instanceof RefreshMessage) {
                RefreshMessage rf = (RefreshMessage)msg;
                Set<PartitionKey> parts = rf.getPartitionKeys().stream().map(PartitionKey::fromString).collect(Collectors.toSet());
                out = new IndexedSnapshotImpl(new HashMap<SportType, Collection<IBetMatch>>(), parts);
            }
            ctx.fireChannelRead(out);
        }
    }
}

