/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.codec;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jayeson.lib.datastructure.PivotBias;
import jayeson.lib.sports.codec.ColumnComparator;
import jayeson.lib.sports.codec.StringPool;

class Util {
    Util() {
    }

    public static <T extends Message> List<T> encodeRecyclables(List<T> records, List<String> sortColumns) {
        if (records.isEmpty()) {
            return new ArrayList();
        }
        if (!sortColumns.isEmpty()) {
            Collections.sort(records, new ColumnComparator(sortColumns));
        }
        List<Descriptors.FieldDescriptor> recyclableFields = Util.getFieldDescriptors(((Message)records.get(0)).getDescriptorForType(), sortColumns);
        return Util.iterateFields(records, recyclableFields, (memory, record, field, toDefault) -> {
            if (toDefault) {
                record.setField(record.getDescriptorForType().findFieldByName("as_default"), (Object)true);
                return;
            }
            Object fieldValue = record.getField(field);
            if (memory.hasField(field) && memory.getField(field).equals(fieldValue)) {
                record.clearField(field);
            }
        });
    }

    public static <T extends Message> List<T> decodeRecyclables(List<T> records, List<String> sortColumns) {
        if (records.isEmpty()) {
            return new ArrayList();
        }
        List<Descriptors.FieldDescriptor> recyclableFields = Util.getFieldDescriptors(((Message)records.get(0)).getDescriptorForType(), sortColumns);
        return Util.iterateFields(records, recyclableFields, (memory, record, field, unUsed) -> {
            boolean asDefault = (Boolean)record.getField(record.getDescriptorForType().findFieldByName("as_default"));
            if (!asDefault && !record.hasField(field)) {
                record.setField(field, memory.getField(field));
            }
        });
    }

    static <T extends Message> List<T> iterateFields(List<T> records, List<Descriptors.FieldDescriptor> columns, RecordFieldLambda handler) {
        Message.Builder memory = null;
        if (!records.isEmpty()) {
            memory = ((Message)records.get(0)).newBuilderForType();
        }
        ArrayList<Message> compressed = new ArrayList<Message>();
        for (Message record : records) {
            Message.Builder mutableCopy = record.toBuilder();
            boolean toDefault = Util.needsAsDefault(mutableCopy, memory, columns);
            for (Descriptors.FieldDescriptor field : columns) {
                handler.accept(memory, mutableCopy, field, toDefault);
                memory.setField(field, mutableCopy.getField(field));
            }
            compressed.add(mutableCopy.build());
        }
        return compressed;
    }

    static boolean needsAsDefault(Message.Builder record, Message.Builder memory, List<Descriptors.FieldDescriptor> columns) {
        for (Descriptors.FieldDescriptor field : columns) {
            if (record.hasField(field) || !memory.hasField(field)) continue;
            return true;
        }
        return false;
    }

    static List<Descriptors.FieldDescriptor> getFieldDescriptors(Descriptors.Descriptor msgType, List<String> fields) {
        return fields.stream().map(column -> msgType.findFieldByName(column)).collect(Collectors.toList());
    }

    public static int encodePivot(PivotBias bias, float pivot) {
        int output = Math.round(Math.abs(pivot) * 4.0f);
        if (bias == PivotBias.HOST) {
            output *= -1;
        }
        return output;
    }

    public static PivotBias decodePivotBias(int pivot) {
        if (pivot < 0) {
            return PivotBias.HOST;
        }
        if (pivot > 0) {
            return PivotBias.GUEST;
        }
        return PivotBias.NEUTRAL;
    }

    public static float decodePivot(int pivot) {
        return Math.abs((float)pivot / 4.0f);
    }

    public static int encodeOdd(float rate, int precision) {
        return (int)Math.round((double)rate * Math.pow(10.0, precision));
    }

    public static float decodeOdd(int rate, int precision) {
        return (float)((double)rate / Math.pow(10.0, precision));
    }

    public static StringPool createStringPool() {
        return new StringPool();
    }

    @FunctionalInterface
    public static interface RecordFieldLambda {
        public void accept(Message.Builder var1, Message.Builder var2, Descriptors.FieldDescriptor var3, boolean var4);
    }
}

