/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.core;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.feed.api.IBetMatch;
import jayeson.lib.feed.api.ISnapshot;
import jayeson.lib.feed.api.PartitionKey;
import jayeson.lib.feed.api.SportType;
import jayeson.lib.sports.core.DeltaTransformingLogic;
import jayeson.lib.sports.core.RecycleBin;
import jayeson.lib.sports.core.SnapshotUtil;
import jayeson.lib.sports.core.TTLCheck;
import jayeson.lib.sports.core.TTLOutgoing;
import jayeson.lib.sports.core.TTLType;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.Incoming;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.IndexedSnapshotImpl;
import jayeson.lib.sports.datastructure.MergeableWrapper;
import jayeson.lib.sports.datastructure.MessageBeforeTransform;
import jayeson.lib.sports.datastructure.TTLWrapper;

public class TTLRestoreCheck
extends TTLCheck {
    private DeltaTransformingLogic transformingLogic;

    public TTLRestoreCheck(RecycleBin recycleBin, Collection<PartitionKey> keys, String stream, DeltaTransformingLogic transformingLogic) {
        super(TTLType.RESTORE, recycleBin, keys, stream);
        this.transformingLogic = transformingLogic;
    }

    @Override
    public MergeableWrapper apply(IndexedSnapshot before) {
        IndexedSnapshot restoredSS = before;
        boolean atleastOneKeyRestored = false;
        HashMap<PartitionKey, Long> restoredKeys = new HashMap<PartitionKey, Long>();
        ArrayList<TTLWrapper> ttlRestoredList = new ArrayList<TTLWrapper>();
        for (PartitionKey key : this.getKeys()) {
            if (!this.getRecycleBin().containData(key)) continue;
            long restoredTime = System.currentTimeMillis();
            restoredKeys.put(key, restoredTime);
            atleastOneKeyRestored = true;
            TTLWrapper ttlRestoreWrapper = this.getRecycleBin().restoreData(restoredSS, key, restoredTime);
            restoredSS = ttlRestoreWrapper.getRemainingSs();
            ttlRestoredList.add(ttlRestoreWrapper);
        }
        ArrayList<DeltaOutgoing> ttlOut = new ArrayList<DeltaOutgoing>();
        if (atleastOneKeyRestored) {
            Sets.SetView nonRestoredKeys = Sets.difference(new HashSet<PartitionKey>(this.getKeys()), restoredKeys.keySet());
            IndexedSnapshotImpl refreshSS = new IndexedSnapshotImpl((Map<SportType, Collection<IBetMatch>>)ISnapshot.matchesBySport(Arrays.asList(new IBetMatch[0])), (Collection<PartitionKey>)nonRestoredKeys);
            restoredSS = SnapshotUtil.combineSnapshots(this.getRecycleBin().getGrp().ADMIN_REFRESH, refreshSS, restoredSS).getAfterSs();
            return this.transformingLogic.transformTTLRestore(ttlRestoredList, this.getRecycleBin().getGrp(), this.getStream(), before, restoredSS, restoredKeys);
        }
        IndexedSnapshotImpl refreshSS = new IndexedSnapshotImpl((Map<SportType, Collection<IBetMatch>>)ISnapshot.matchesBySport(Arrays.asList(new IBetMatch[0])), this.getKeys());
        Incoming incoming = new Incoming((IMessageClass<?>)this.getRecycleBin().getGrp().ADMIN_REFRESH, this.getStream(), refreshSS);
        MessageBeforeTransform msg = SnapshotUtil.combineSnapshots(this.getRecycleBin().getGrp().ADMIN_REFRESH, refreshSS, before);
        ttlOut.add(new TTLOutgoing(this.getTtlType(), incoming, msg.getAfterSs(), before));
        MergeableWrapper wrap = new MergeableWrapper();
        wrap.setDeltaOut(ttlOut);
        wrap.setAfter(msg.getAfterSs());
        return wrap;
    }
}

