/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import java.util.Collection;
import java.util.function.Consumer;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.dispatch.IDispatchableWrapper;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.WrapperImpl;

public class IndicatorWrapper
extends WrapperImpl
implements IDispatchableWrapper {
    private Outgoing outgoing;
    private Collection<IEndPointDispatcher> epds;

    public IndicatorWrapper(Outgoing outgoing, IEndPointGroup epg, String stream) {
        this(outgoing, epg, stream, null);
    }

    public IndicatorWrapper(Outgoing outgoing, IEndPointGroup epg, String stream, Collection<IEndPointDispatcher> epds) {
        super(epg, stream);
        this.outgoing = outgoing;
        this.epds = epds;
    }

    @Override
    public Consumer<Void> process() {
        return Void2 -> {
            if (this.epds == null) {
                Collection<IEndPointDispatcher> epds = this.getEpg().getEPDs(this.getStream());
                this.submitToEpds(epds, this.outgoing);
            } else {
                this.submitToEpds(this.epds, this.outgoing);
            }
        };
    }

    private void submitToEpds(Collection<IEndPointDispatcher> epds, Outgoing outgoing) {
        for (IEndPointDispatcher epd : epds) {
            if (!epd.isReadyToDispatch()) continue;
            if (epd.getOldEPG() == this.getEpg()) {
                epd.submitToDispatchingQueue(outgoing);
                continue;
            }
            if (!epd.isReceivingRelevantDeltaFromNewEPG()) continue;
            epd.submitToInputQueue(outgoing);
        }
    }

    public Outgoing getDelta() {
        return this.outgoing;
    }

    @Override
    public Consumer<Void> postProcess() {
        return null;
    }
}

