/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import java.util.Collection;
import java.util.function.Consumer;
import jayeson.lib.sports.datastructure.DeltaOutgoing;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.dispatch.IDispatchableWrapper;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.WrapperImpl;

public class PartialSnapshotWrapper
extends WrapperImpl
implements IDispatchableWrapper {
    private DeltaOutgoing delta;

    public PartialSnapshotWrapper(DeltaOutgoing delta, IEndPointGroup epg, String stream) {
        super(epg, stream);
        this.delta = delta;
    }

    @Override
    public Consumer<Void> process() {
        return Void2 -> {
            IEndPointGroup epg = this.getEpg();
            epg.submitForProcessing(v -> {
                Collection<Outgoing> outgoingList = epg.generate(this);
                Collection<IEndPointDispatcher> epds = epg.getEPDs(this.getStream());
                for (IEndPointDispatcher epd : epds) {
                    if (!epd.isReadyToDispatch()) continue;
                    if (epd.getOldEPG() == epg) {
                        outgoingList.forEach(out -> epd.submitToDispatchingQueue((Outgoing)out));
                        continue;
                    }
                    if (epd.getNewEPG() != epg || !epd.isReceivingRelevantDeltaFromNewEPG()) continue;
                    outgoingList.forEach(out -> epd.submitToInputQueue((Outgoing)out));
                }
                return true;
            });
        };
    }

    public DeltaOutgoing getDelta() {
        return this.delta;
    }

    @Override
    public Consumer<Void> postProcess() {
        return null;
    }
}

