/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.dispatch;

import java.util.Collection;
import java.util.function.Consumer;
import jayeson.lib.sports.datastructure.IndexedSnapshot;
import jayeson.lib.sports.datastructure.Outgoing;
import jayeson.lib.sports.dispatch.IDispatchableWrapper;
import jayeson.lib.sports.dispatch.IEndPointDispatcher;
import jayeson.lib.sports.dispatch.IEndPointGroup;
import jayeson.lib.sports.dispatch.WrapperImpl;

public class TTLSnapshotWrapper
extends WrapperImpl
implements IDispatchableWrapper {
    private IndexedSnapshot fullSnapshot;
    private IndexedSnapshot restoredSnapshot;
    private long ttlRemovedTime;

    public TTLSnapshotWrapper(IndexedSnapshot fullSnapshot, IndexedSnapshot restoredSnapshot, IEndPointGroup epg, String stream, long ttlRemovedTime) {
        super(epg, stream);
        this.fullSnapshot = fullSnapshot;
        this.restoredSnapshot = restoredSnapshot;
        this.ttlRemovedTime = ttlRemovedTime;
    }

    @Override
    public Consumer<Void> process() {
        return Void2 -> {
            IEndPointGroup epg = this.getEpg();
            epg.submitForProcessing(v -> {
                Collection<IEndPointDispatcher> epds = epg.getEPDs(this.getStream());
                Collection<Outgoing> fssDeltas = null;
                Outgoing restoreMsg = this.getEpg().generate(this, false).iterator().next();
                for (IEndPointDispatcher epd : epds) {
                    if (!epd.isReadyToDispatch()) continue;
                    long connectedTime = epg.getEpdConnectedTime(epd);
                    if (connectedTime > this.ttlRemovedTime) {
                        if (fssDeltas == null) {
                            fssDeltas = this.getEpg().generate(this, true);
                        }
                        for (Outgoing mw : fssDeltas) {
                            this.submitToEpd(epd, mw);
                        }
                        continue;
                    }
                    this.submitToEpd(epd, restoreMsg);
                }
                return true;
            });
        };
    }

    private void submitToEpd(IEndPointDispatcher epd, Outgoing outgoing) {
        if (epd.getOldEPG() == this.getEpg()) {
            epd.submitToDispatchingQueue(outgoing);
        } else if (epd.isReceivingRelevantDeltaFromNewEPG()) {
            epd.submitToInputQueue(outgoing);
        }
    }

    public IndexedSnapshot getFullSnapshot() {
        return this.fullSnapshot;
    }

    public IndexedSnapshot getRestoredSnapshot() {
        return this.restoredSnapshot;
    }

    @Override
    public Consumer<Void> postProcess() {
        return null;
    }
}

