/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.sports.receive;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.MetaInformationCode;
import jayeson.lib.delivery.api.events.EPEvent;
import jayeson.lib.delivery.api.messages.IMessageClass;
import jayeson.lib.delivery.api.messages.MessageWrapper;
import jayeson.lib.delivery.core.keepalive.KeepAliveGroupProcessor;
import jayeson.lib.delivery.core.metainfo.StreamNameCode;
import jayeson.lib.delivery.module.subscriber.StreamId;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionErrorEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStartEvent;
import jayeson.lib.delivery.module.subscriber.events.ConsumptionStopEvent;
import jayeson.lib.sports.codec.FilterData;
import jayeson.lib.sports.codec.FilterRequest;
import jayeson.lib.sports.codec.StartSubscribeFeed;
import jayeson.lib.sports.core.SportsFeedMessageGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InEndPointEventHandler
implements IEndPointListener {
    private static Logger log = LoggerFactory.getLogger(InEndPointEventHandler.class);
    private FilterData filterData;
    private SportsFeedMessageGroup sportsFeedGroup;
    private StreamNameCode streamNameCode;
    private ConcurrentHashMap<StreamId, IEndPoint> streamSources = new ConcurrentHashMap();
    private StartSubscribeFeed startMessage;
    private KeepAliveGroupProcessor keepAliveGroupProcessor;
    private AtomicInteger filterRequestCounter;

    @Inject
    public InEndPointEventHandler(StartSubscribeFeed startMessage, SportsFeedMessageGroup sportsFeedGroup, StreamNameCode streamNameCode, KeepAliveGroupProcessor keepAliveGroupProcessor) {
        this.startMessage = startMessage;
        this.sportsFeedGroup = sportsFeedGroup;
        this.streamNameCode = streamNameCode;
        this.keepAliveGroupProcessor = keepAliveGroupProcessor;
        this.filterRequestCounter = new AtomicInteger();
    }

    public void onEvent(EPEvent event) {
        if (event instanceof ConsumptionStartEvent) {
            ConsumptionStartEvent castedEvent = (ConsumptionStartEvent)event;
            for (StreamId streamId : castedEvent.getStreams()) {
                MessageWrapper mw;
                if (!streamId.group.equals(this.sportsFeedGroup.id())) continue;
                log.info("Received ConsumptionStartEvent for {} from {}", (Object)streamId.getIdentifier(), (Object)event.getEndpoint().getIdentifier());
                this.streamSources.put(streamId, event.getEndpoint());
                if (this.filterData != null) {
                    log.info("Sending Filter {} to the Stream {}", (Object)this.filterData.getFilter(), (Object)streamId.getIdentifier());
                    FilterRequest filterRequest = new FilterRequest(-1, this.filterData);
                    mw = new MessageWrapper((Object)filterRequest, (IMessageClass)this.sportsFeedGroup.FILTER_SET);
                    this.sendMessage(streamId, mw);
                } else {
                    log.info("No Filter set.Sending empty filter message to Stream {}", (Object)streamId.getIdentifier());
                    String requestId = String.valueOf(-1);
                    mw = new MessageWrapper((Object)requestId, (IMessageClass)this.sportsFeedGroup.FILTER_REMOVE);
                    this.sendMessage(streamId, mw);
                }
                log.info("Sending start_subscribe message to stream {} with exclusions {}", (Object)streamId.getIdentifier(), this.startMessage.getExclude());
                MessageWrapper mw2 = new MessageWrapper((Object)this.startMessage, (IMessageClass)this.sportsFeedGroup.ADMIN_START_SUBSCRIBE_FEED);
                this.sendMessage(streamId, mw2);
            }
        } else if (event instanceof ConsumptionErrorEvent) {
            for (StreamId streamId : ((ConsumptionErrorEvent)event).getStreams()) {
                if (!streamId.group.equals(this.sportsFeedGroup.id())) continue;
                log.info("Received ConsumptionErrorEvent for {} from {}", (Object)streamId.getIdentifier(), (Object)event.getEndpoint().getIdentifier());
                this.streamSources.remove(streamId);
            }
        } else if (event instanceof ConsumptionStopEvent) {
            for (StreamId streamId : ((ConsumptionStopEvent)event).getStreams()) {
                if (!streamId.group.equals(this.sportsFeedGroup.id())) continue;
                log.info("Received ConsumptionStopEvent for {} from {}", (Object)streamId.getIdentifier(), (Object)event.getEndpoint().getIdentifier());
                this.streamSources.remove(streamId);
            }
        } else {
            log.warn("InEndPointEventHandler received event {} from {}", (Object)event.toString(), (Object)event.getEndpoint().getIdentifier());
        }
    }

    public void sendMessage(StreamId streamId, MessageWrapper mw) {
        mw.addMetaInformation((MetaInformationCode)this.streamNameCode, streamId.stream);
        IEndPoint ep = this.streamSources.get(streamId);
        if (ep == null) {
            log.error("No Endpoint present corresponding to stream {}. Unable to send message", (Object)streamId.getIdentifier());
        } else {
            try {
                ep.send(mw);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
    }

    public ConcurrentHashMap<StreamId, IEndPoint> getStreamSources() {
        return this.streamSources;
    }

    public void setStreamSources(ConcurrentHashMap<StreamId, IEndPoint> streamSources) {
        this.streamSources = streamSources;
    }

    public FilterData getFilter() {
        return this.filterData;
    }

    public void setFilter(FilterData filter) {
        this.filterData = filter;
    }

    public SportsFeedMessageGroup getSoccerFeedGroup() {
        return this.sportsFeedGroup;
    }

    public void excludeRateId() {
        this.startMessage.excludeRateId();
    }

    public StreamNameCode getStreamNameCode() {
        return this.streamNameCode;
    }

    public Set<Integer> updateFilter(FilterData filterData, boolean initialFilter) {
        this.filterData = filterData;
        return this.sendFilter(filterData, initialFilter);
    }

    private Set<Integer> sendFilter(FilterData filterData, boolean initialFilter) {
        if (initialFilter) {
            FilterRequest request = new FilterRequest(-1, filterData);
            for (StreamId streamId : this.streamSources.keySet()) {
                this.sendFilterRequest(request, streamId);
            }
            return new HashSet<Integer>(Arrays.asList(-1));
        }
        HashSet<Integer> requestIds = new HashSet<Integer>();
        for (StreamId streamId : this.streamSources.keySet()) {
            int requestId = this.filterRequestCounter.incrementAndGet();
            FilterRequest request = new FilterRequest(requestId, filterData);
            this.sendFilterRequest(request, streamId);
            requestIds.add(requestId);
        }
        return requestIds;
    }

    private void sendFilterRequest(FilterRequest filterRequest, StreamId streamId) {
        FilterData filterData = filterRequest.getFilterData();
        if (filterData != null) {
            log.info("Sending Filter {} to the Stream {}", (Object)filterData.getFilter(), (Object)streamId.getIdentifier());
            MessageWrapper mw = new MessageWrapper((Object)filterRequest, (IMessageClass)this.sportsFeedGroup.FILTER_SET);
            this.sendMessage(streamId, mw);
        } else {
            log.info("No Filter set.Sending empty filter message to Stream {}", (Object)streamId.getIdentifier());
            MessageWrapper mw = new MessageWrapper((Object)String.valueOf(filterRequest.getRequestId()), (IMessageClass)this.sportsFeedGroup.FILTER_REMOVE);
            this.sendMessage(streamId, mw);
        }
    }

    public Map<CompletableFuture<Void>, IEndPoint> sendKeepAlive(long timeOut) {
        HashSet<IEndPoint> uniqueEndPoints = new HashSet<IEndPoint>(this.streamSources.values());
        return this.keepAliveGroupProcessor.sendKeepAlive(uniqueEndPoints, timeOut);
    }
}

