/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import jayeson.lib.delivery.api.IEndPoint;
import jayeson.lib.delivery.api.IEndPointListener;
import jayeson.lib.delivery.api.events.EPConnectedEvent;
import jayeson.lib.delivery.api.events.EPDisconnectedEvent;
import jayeson.lib.delivery.core.IEndPointCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEndPointMonitor
extends ChannelInboundHandlerAdapter
implements IEndPointCreator {
    private static Logger log = LoggerFactory.getLogger(AbstractEndPointMonitor.class);
    protected IEndPointListener listener;
    private IEndPoint endPoint;

    public void channelActive(ChannelHandlerContext ctx) {
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        log.info("EndPoint connected {}:{}", (Object)socketAddress.getHostString(), (Object)socketAddress.getPort());
        SocketChannel s = (SocketChannel)ctx.channel();
        this.endPoint = this.create(s);
        EPConnectedEvent epConnectedEvent = new EPConnectedEvent(this.endPoint);
        this.listener.onEvent(epConnectedEvent);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        log.info("EndPoint disconnected {}:{}", (Object)socketAddress.getHostString(), (Object)socketAddress.getPort());
        EPDisconnectedEvent epDisconnectedEvent = new EPDisconnectedEvent(this.endPoint);
        this.listener.onEvent(epDisconnectedEvent);
    }

    public void setListener(IEndPointListener listener) {
        this.listener = listener;
    }

    public IEndPoint getEndPoint() {
        return this.endPoint;
    }
}

