/*
 * Decompiled with CFR 0.152.
 */
package jayeson.lib.delivery.core;

import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventMonitor
implements SubscriberExceptionHandler {
    private static Logger log = LoggerFactory.getLogger(EventMonitor.class);
    public static final EventMonitor INSTANCE = new EventMonitor();

    private EventMonitor() {
    }

    @Subscribe
    public void processDeadEvent(DeadEvent e) {
        log.trace("DeadEvent.No Registered subscriber for event {} originated from {}", e.getEvent(), e.getSource());
    }

    public void handleException(Throwable exception, SubscriberExceptionContext ctx) {
        log.error("Exception while dispatching event.Event:{},Bus:{},Subscriber:{},Method:{}", new Object[]{ctx.getEvent(), ctx.getEventBus(), ctx.getSubscriber(), ctx.getSubscriberMethod().toGenericString(), exception});
    }
}

